/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.common.collection.LRUHashMap;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.scripting.AbstractScriptTestCase;
import com.xceptance.xlt.api.tests.AbstractTestCase;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.scripting.PageLoadTimeoutException;
import com.xceptance.xlt.engine.scripting.Script;
import com.xceptance.xlt.engine.scripting.ScriptException;
import com.xceptance.xlt.engine.scripting.TestDataUtils;
import com.xceptance.xlt.engine.scripting.VariableScope;
import com.xceptance.xlt.engine.scripting.XlteniumScriptInterpreter;
import com.xceptance.xlt.engine.scripting.util.CommonScriptCommands;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.WebClient;

public class TestContext {
    private static final Map<ThreadGroup, TestContext> CONTEXTS = new ConcurrentHashMap<ThreadGroup, TestContext>();
    private static final String PROP_TIMEOUT = "com.xceptance.xlt.scripting.defaultTimeout";
    private static final String PROP_IMPLICIT_TIMEOUT = "com.xceptance.xlt.scripting.defaultImplicitWaitTimeout";
    private static final String DATA_CACHE_SIZE = "com.xceptance.xlt.scripting.dataCacheSize";
    private static final long defaultTimeout = XltProperties.getInstance().getProperty("com.xceptance.xlt.scripting.defaultTimeout", 30000L);
    private final long defaultImplicitTimeout = XltProperties.getInstance().getProperty("com.xceptance.xlt.scripting.defaultImplicitWaitTimeout", 1000L);
    private final AtomicLong implicitTimeout = new AtomicLong(this.defaultImplicitTimeout);
    private static final int dataCacheSize = XltProperties.getInstance().getProperty("com.xceptance.xlt.scripting.dataCacheSize", 32);
    private final AtomicLong timeout = new AtomicLong(defaultTimeout);
    private Timer timer = new Timer();
    private VariableScope _scope;
    private VariableScope _rScope;
    private String _baseUrl = "";
    private WeakReference<WebClient> _webClient;
    private WeakReference<CommonScriptCommands> _adapter;
    private volatile Map<String, String> _globalData;
    private static final LRUHashMap<Object, Map<String, String>> LOADED_DATA = new LRUHashMap(dataCacheSize);
    private static final LRUHashMap<String, Map<String, String>> LOADED_PKG_DATA = new LRUHashMap(dataCacheSize);

    private TestContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestContext getCurrent() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        TestContext c = CONTEXTS.get(threadGroup);
        if (c == null) {
            ThreadGroup threadGroup2 = threadGroup;
            synchronized (threadGroup2) {
                c = CONTEXTS.get(threadGroup);
                if (c == null) {
                    c = new TestContext();
                    CONTEXTS.put(threadGroup, c);
                }
            }
        }
        return c;
    }

    public <T> T callAndWait(Callable<T> action) {
        return this.getTimer().run(action);
    }

    public long getDefaultImplicitTimeout() {
        return this.defaultImplicitTimeout;
    }

    public long getImplicitTimeout() {
        return this.implicitTimeout.get();
    }

    public void setImplicitTimeout(long timeout) {
        long to = Math.max(0L, timeout);
        this.implicitTimeout.set(to);
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public long getTimeout() {
        return this.timeout.get();
    }

    public void setTimeout(long timeout) {
        long to = Math.max(0L, timeout);
        this.timeout.set(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        TestContext testContext = this;
        synchronized (testContext) {
            if (this.timer != null) {
                this.timer.stop();
            }
        }
        this.setAdapter(null);
        this.setWebClient(null);
        this.setTimer(null);
        this.setScope(null);
    }

    private synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        return this.timer;
    }

    private synchronized void setTimer(Timer timer) {
        this.timer = timer;
    }

    private Map<String, String> getData(Object key) {
        if (key instanceof Script) {
            return this.getData((Script)key);
        }
        return this.getData(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getData(Script script) {
        HashMap<String, String> data = (HashMap<String, String>)LOADED_DATA.get(script);
        if (data == null) {
            LRUHashMap<Object, Map<String, String>> lRUHashMap = LOADED_DATA;
            synchronized (lRUHashMap) {
                data = (Map)LOADED_DATA.get(script);
                if (data == null) {
                    data = new HashMap<String, String>(this.getPackageTestData(script));
                    data.putAll(TestDataUtils.getTestData(script));
                    LOADED_DATA.put(script, data);
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getData(Class<?> clazz) {
        HashMap<String, String> data = (HashMap<String, String>)LOADED_DATA.get(clazz);
        if (data == null) {
            LRUHashMap<Object, Map<String, String>> lRUHashMap = LOADED_DATA;
            synchronized (lRUHashMap) {
                data = (Map)LOADED_DATA.get(clazz);
                if (data == null) {
                    data = new HashMap<String, String>(TestContext.getPackageTestData(clazz));
                    data.putAll(TestDataUtils.getTestData(clazz));
                    LOADED_DATA.put(clazz, data);
                }
            }
        }
        return data;
    }

    public void popScope() {
        VariableScope scope = this.getScope();
        if (scope != null) {
            scope = scope.getEnclosingScope();
        }
        this.setScope(scope);
    }

    public void pushScope(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        VariableScope scope = this.getScope();
        if (scope == null) {
            scope = new VariableScope(new HashMap<String, String>());
            this.getGlobalData();
        }
        if (object instanceof AbstractTestCase) {
            scope = new VariableScope(((AbstractTestCase)object).getTestDataSet(), scope);
        }
        if (!(object instanceof AbstractScriptTestCase)) {
            scope = new VariableScope(this.getData(object), scope);
        }
        this.setScope(scope);
    }

    private Map<String, String> getPackageTestData(Script script) {
        File baseDir = XlteniumScriptInterpreter.SCRIPTS_DIRECTORY;
        File scriptFile = script.getScriptFile();
        ArrayList<String> parts = new ArrayList<String>();
        File dir = scriptFile;
        while ((dir = dir.getParentFile()) != null && !dir.equals(baseDir)) {
            parts.add(0, dir.getName());
        }
        String packageName = StringUtils.join(parts, (char)'.');
        return TestContext.getPackageTestData(null, baseDir.getAbsolutePath(), packageName);
    }

    private static Map<String, String> getPackageTestData(Class<?> clazz, String baseDir, String packageName) {
        ArrayList<String> pkgs = new ArrayList<String>();
        String pkgName = packageName;
        int idx = pkgName.lastIndexOf(46);
        while (idx > -1) {
            pkgs.add(pkgName);
            pkgName = pkgName.substring(0, idx);
            idx = pkgName.lastIndexOf(46);
        }
        if (!"".equals(pkgName)) {
            pkgs.add(pkgName);
        }
        HashMap<String, String> m = new HashMap<String, String>(TestContext.getOrLoadPackageData(clazz, baseDir, ""));
        for (int i = pkgs.size() - 1; i >= 0; --i) {
            m.putAll(TestContext.getOrLoadPackageData(clazz, baseDir, (String)pkgs.get(i)));
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getOrLoadPackageData(Class<?> clazz, String baseDir, String packageName) {
        Map<String, String> data = (Map<String, String>)LOADED_PKG_DATA.get(packageName);
        if (data == null) {
            LRUHashMap<String, Map<String, String>> lRUHashMap = LOADED_PKG_DATA;
            synchronized (lRUHashMap) {
                data = (Map)LOADED_PKG_DATA.get(packageName);
                if (data == null) {
                    data = TestDataUtils.getPackageTestData(clazz, baseDir, packageName);
                    LOADED_PKG_DATA.put(packageName, data);
                }
            }
        }
        return data;
    }

    private static Map<String, String> getPackageTestData(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        String packageName = pkg == null ? "" : pkg.getName();
        try {
            String baseDir;
            if (packageName.length() > 0) {
                int nbPkgDelims = StringUtils.countMatches((CharSequence)packageName, (CharSequence)".");
                StringBuilder sb = new StringBuilder();
                sb.append("..");
                for (int i = 0; i < nbPkgDelims; ++i) {
                    sb.append('/').append("..");
                }
                baseDir = sb.toString();
            } else {
                baseDir = ".";
            }
            return TestContext.getPackageTestData(clazz, baseDir, packageName);
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error("Failed to load test data for package '" + packageName + "'.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public synchronized void setWebClient(WebClient webClient) {
        this._webClient = new WeakReference<WebClient>(webClient);
    }

    public synchronized WebClient getWebClient() {
        return (WebClient)this._webClient.get();
    }

    private synchronized void setScope(VariableScope scope) {
        this._scope = scope;
        this._rScope = null;
    }

    private synchronized VariableScope getScope() {
        return this._scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VariableScope getRScope() {
        VariableScope scope = this.getScope();
        if (scope == null) {
            return null;
        }
        if (this._rScope == null) {
            TestContext testContext = this;
            synchronized (testContext) {
                if (this._rScope == null) {
                    this._rScope = new VariableScope(this._globalData, scope);
                }
            }
        }
        return this._rScope;
    }

    public synchronized CommonScriptCommands getAdapter() {
        return (CommonScriptCommands)this._adapter.get();
    }

    public synchronized void setAdapter(CommonScriptCommands adapter) {
        this._adapter = new WeakReference<CommonScriptCommands>(adapter);
    }

    public synchronized Map<String, String> getGlobalTestData() {
        return this._globalData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGlobalData() {
        if (this._globalData == null) {
            TestContext testContext = this;
            synchronized (testContext) {
                if (this._globalData == null) {
                    this._globalData = TestDataUtils.getGlobalTestData();
                }
            }
        }
    }

    private VariableScope getTopScope() {
        VariableScope scope = this.getScope();
        if (scope != null) {
            while (scope.hasEnclosingScope()) {
                scope = scope.getEnclosingScope();
            }
        }
        return scope;
    }

    public void storeValue(String key, String value) {
        VariableScope scope = this.getTopScope();
        if (scope != null) {
            scope.storeValue(key, value);
        }
    }

    public String resolve(String resolvable) {
        return this.getRScope().resolve(resolvable);
    }

    public String resolveKey(String key) {
        return this.getRScope().resolveKey(key);
    }

    public synchronized String getBaseUrl() {
        return this._baseUrl;
    }

    public synchronized void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl == null ? "" : baseUrl;
    }

    private class Timer {
        private final ExecutorService service = Executors.newSingleThreadExecutor();

        private Timer() {
        }

        private <T> T run(final Callable<T> callable) {
            Future future = this.service.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    Thread.currentThread().setName(Session.getCurrent().getUserID() + "-timer");
                    return callable.call();
                }
            });
            try {
                return future.get(TestContext.this.timeout.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ScriptException("Interrupted while waiting for action to finish", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            catch (TimeoutException e) {
                throw new PageLoadTimeoutException("Timed out waiting for page to load", e);
            }
        }

        private void stop() {
            this.service.shutdownNow();
            try {
                this.service.awaitTermination(TestContext.this.timeout.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

