/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics.otel;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.engine.metrics.MetricsReporter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.logs.Severity;
import java.time.Instant;
import java.util.function.Consumer;

public class OtelMetricsReporter
implements MetricsReporter {
    private static final String LOG_TYPE_ERROR = "error";
    private static final String LOG_TYPE_EVENT = "event";
    private final OpenTelemetry _otel;

    public OtelMetricsReporter(OpenTelemetry otel) {
        this._otel = otel;
    }

    @Override
    public void reportMetrics(Data data) {
        if (data instanceof EventData) {
            this.reportEvent((EventData)data);
        } else if (data instanceof TransactionData) {
            this.reportTransaction((TransactionData)data);
        }
    }

    private void reportEvent(EventData eventData) {
        this.logRecord(record -> {
            record.setObservedTimestamp(Instant.now());
            record.setTimestamp(Instant.ofEpochMilli(eventData.getTime()));
            record.setSeverity(Severity.WARN);
            record.setBody(eventData.getMessage());
            record.setAttribute(LogRecordAttributes.LOG_TYPE, (Object)LOG_TYPE_EVENT);
            record.setAttribute(LogRecordAttributes.EVENT_NAME, (Object)eventData.getName());
            record.setAttribute(LogRecordAttributes.EVENT_SCENARIO, (Object)eventData.getTestCaseName());
            record.setAttribute(LogRecordAttributes.EVENT_USER, (Object)Session.getCurrent().getUserNumber());
        });
    }

    private void reportTransaction(TransactionData txnData) {
        if (txnData.hasFailed()) {
            this.logRecord(record -> {
                record.setObservedTimestamp(Instant.now());
                record.setTimestamp(Instant.ofEpochMilli(txnData.getEndTime()));
                record.setSeverity(Severity.ERROR);
                record.setBody(txnData.getFailureStackTrace());
                record.setAttribute(LogRecordAttributes.LOG_TYPE, (Object)LOG_TYPE_ERROR);
                record.setAttribute(LogRecordAttributes.ERROR_ACTION, (Object)txnData.getFailedActionName());
                record.setAttribute(LogRecordAttributes.ERROR_MESSAGE, (Object)txnData.getFailureMessage());
                record.setAttribute(LogRecordAttributes.ERROR_USER, (Object)Long.valueOf(txnData.getTestUserNumber()));
                record.setAttribute(LogRecordAttributes.ERROR_SCENARIO, (Object)txnData.getName());
            });
        }
    }

    private void logRecord(Consumer<LogRecordBuilder> logRecordConfigurator) {
        logRecordConfigurator.andThen(LogRecordBuilder::emit).accept(this.getLogger().logRecordBuilder());
    }

    private Logger getLogger() {
        return this._otel.getLogsBridge().get(this.getClass().getName());
    }

    static final class LogRecordAttributes {
        static final AttributeKey<String> LOG_TYPE = AttributeKey.stringKey((String)"xlt.log_type");
        static final AttributeKey<String> ERROR_ACTION = AttributeKey.stringKey((String)"xlt.error.action");
        static final AttributeKey<String> ERROR_MESSAGE = AttributeKey.stringKey((String)"xlt.error.message");
        static final AttributeKey<String> ERROR_SCENARIO = AttributeKey.stringKey((String)"xlt.error.scenario");
        static final AttributeKey<Long> ERROR_USER = AttributeKey.longKey((String)"xlt.error.user");
        static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey((String)"xlt.event.name");
        static final AttributeKey<String> EVENT_SCENARIO = AttributeKey.stringKey((String)"xlt.event.scenario");
        static final AttributeKey<Long> EVENT_USER = AttributeKey.longKey((String)"xlt.event.user");

        LogRecordAttributes() {
        }
    }
}

