/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.httprequest;

import com.xceptance.common.util.ParameterCheckUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.json.JSONObject;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HttpResponse {
    private final WebResponse webResponse;

    public HttpResponse(WebResponse webResponse) {
        ParameterCheckUtils.isNotNull(webResponse, "webResponse");
        this.webResponse = webResponse;
    }

    public HttpResponse checkStatusCode(int expectedStatusCode) {
        Assert.assertEquals((String)"Status code does not match", (long)expectedStatusCode, (long)this.webResponse.getStatusCode());
        return this;
    }

    public HttpResponse checkStatusMessage(String expectedStatusMessage) {
        Assert.assertEquals((String)"Status message does not match", (Object)expectedStatusMessage, (Object)this.webResponse.getStatusMessage());
        return this;
    }

    public HttpResponse checkContentType(String expectedContentType) {
        Assert.assertEquals((String)"Content type does not match", (Object)expectedContentType, (Object)this.webResponse.getContentType());
        return this;
    }

    public HttpResponse checkHeaderValue(String name, String expectedValue) {
        Assert.assertFalse((String)"Header name can not be blank", (boolean)StringUtils.isBlank((CharSequence)name));
        Assert.assertEquals((String)("Header " + name + " does not match"), (Object)expectedValue, (Object)this.webResponse.getResponseHeaderValue(name));
        return this;
    }

    public int getStatusCode() {
        return this.webResponse.getStatusCode();
    }

    public String getStatusMessage() {
        return this.webResponse.getStatusMessage();
    }

    public Charset getContentCharset() {
        return this.webResponse.getContentCharset();
    }

    public String getContentType() {
        return this.webResponse.getContentType();
    }

    public long getContentLength() {
        return this.webResponse.getContentLength();
    }

    public String getHeaderValue(String name) {
        return this.webResponse.getResponseHeaderValue(name);
    }

    public List<NameValuePair> getHeaders() {
        return this.webResponse.getResponseHeaders();
    }

    public String getContentAsString() {
        return this.webResponse.getContentAsString();
    }

    public String getContentAsString(Charset encoding) {
        return this.webResponse.getContentAsString(encoding);
    }

    public JSONObject getContentAsJSONObject() {
        return new JSONObject(this.webResponse.getContentAsString());
    }

    public Document getContentAsDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        return documentBuilder.parse(this.webResponse.getContentAsStream());
    }

    public WebResponse getWebResponse() {
        return this.webResponse;
    }
}

