/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.xceptance.xlt.engine.har.model.HarContent;
import com.xceptance.xlt.engine.har.model.HarCookie;
import com.xceptance.xlt.engine.har.model.HarHeader;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"status", "statusText", "httpVersion", "cookies", "headers", "content", "redirectURL", "headersSize", "bodySize", "comment"})
public class HarResponse {
    private final int status;
    private final String statusText;
    private final String httpVersion;
    private final List<HarCookie> cookies;
    private final List<HarHeader> headers;
    private final HarContent content;
    private final String redirectURL;
    private final long headersSize;
    private final long bodySize;
    private final String comment;

    @JsonCreator
    public HarResponse(@JsonProperty(value="status") int status, @JsonProperty(value="statusText") String statusText, @JsonProperty(value="httpVersion") String httpVersion, @JsonProperty(value="cookies") List<HarCookie> cookies, @JsonProperty(value="headers") List<HarHeader> headers, @JsonProperty(value="content") HarContent content, @JsonProperty(value="redirectURL") String redirectURL, @JsonProperty(value="headersSize") long headersSize, @JsonProperty(value="bodySize") long bodySize, @JsonProperty(value="comment") String comment) {
        this.status = status;
        this.statusText = statusText;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.content = content;
        this.redirectURL = redirectURL;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.comment = comment;
    }

    public HarContent getContent() {
        return this.content;
    }

    public List<HarHeader> getHeaders() {
        return this.headers;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public int getStatus() {
        return this.status;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getComment() {
        return this.comment;
    }

    public List<HarCookie> getCookies() {
        return this.cookies;
    }

    public long getHeadersSize() {
        return this.headersSize;
    }

    public String toString() {
        return "HarResponse [content = " + this.content + ", headers = " + this.headers + ", bodySize = " + this.bodySize + ", httpVersion = " + this.httpVersion + ", status = " + this.status + ", redirectURL = " + this.redirectURL + ", statusText = " + this.statusText + ", comment = " + this.comment + ", cookies = " + this.cookies + ", headersSize = " + this.headersSize + "]";
    }

    public static class Builder {
        private int status;
        private String statusText;
        private String httpVersion;
        private List<HarCookie> cookies = new ArrayList<HarCookie>();
        private List<HarHeader> headers = new ArrayList<HarHeader>();
        private HarContent content;
        private String redirectURL;
        private long headersSize = -1L;
        private long bodySize = -1L;
        private String comment;

        public Builder withStatus(int status) {
            this.status = status;
            return this;
        }

        public Builder withStatusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public Builder withHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public Builder withCookies(List<HarCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public Builder withHeaders(List<HarHeader> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withContent(HarContent content) {
            this.content = content;
            return this;
        }

        public Builder withRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public Builder withHeadersSize(long headersSize) {
            this.headersSize = headersSize;
            return this;
        }

        public Builder withBodySize(long bodySize) {
            this.bodySize = bodySize;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarResponse build() {
            return new HarResponse(this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment);
        }
    }
}

