/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.xceptance.xlt.engine.har.model.HarCookie;
import com.xceptance.xlt.engine.har.model.HarHeader;
import com.xceptance.xlt.engine.har.model.HarPostData;
import com.xceptance.xlt.engine.har.model.HarQueryString;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"method", "url", "httpVersion", "cookies", "headers", "queryString", "postData", "headersSize", "bodySize", "comment"})
public class HarRequest {
    private final String method;
    private final String url;
    private final String httpVersion;
    private final List<HarCookie> cookies;
    private final List<HarHeader> headers;
    private final List<HarQueryString> queryString;
    private final HarPostData postData;
    private final long headersSize;
    private final long bodySize;
    private final String comment;

    @JsonCreator
    public HarRequest(@JsonProperty(value="headersSize") long headersSize, @JsonProperty(value="method") String method, @JsonProperty(value="url") String url, @JsonProperty(value="httpVersion") String httpVersion, @JsonProperty(value="cookies") List<HarCookie> cookies, @JsonProperty(value="headers") List<HarHeader> headers, @JsonProperty(value="queryString") List<HarQueryString> queryString, @JsonProperty(value="postData") HarPostData postData, @JsonProperty(value="bodySize") long bodySize, @JsonProperty(value="comment") String comment) {
        this.headersSize = headersSize;
        this.method = method;
        this.url = url;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.queryString = queryString;
        this.postData = postData;
        this.bodySize = bodySize;
        this.comment = comment;
    }

    public List<HarHeader> getHeaders() {
        return this.headers;
    }

    public List<HarQueryString> getQueryString() {
        return this.queryString;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public HarPostData getPostData() {
        return this.postData;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getMethod() {
        return this.method;
    }

    public String getComment() {
        return this.comment;
    }

    public List<HarCookie> getCookies() {
        return this.cookies;
    }

    public String getUrl() {
        return this.url;
    }

    public long getHeadersSize() {
        return this.headersSize;
    }

    public String toString() {
        return "HarRequest [headers = " + this.headers + ", queryString = " + this.queryString + ", bodySize = " + this.bodySize + ", postData = " + this.postData + ", httpVersion = " + this.httpVersion + ", method = " + this.method + ", comment = " + this.comment + ", cookies = " + this.cookies + ", url = " + this.url + ", headersSize = " + this.headersSize + "]";
    }

    public static class Builder {
        private String method;
        private String url;
        private String httpVersion;
        private List<HarCookie> cookies = new ArrayList<HarCookie>();
        private List<HarHeader> headers = new ArrayList<HarHeader>();
        private List<HarQueryString> queryString = new ArrayList<HarQueryString>();
        private HarPostData postData;
        private long bodySize = -1L;
        private long headersSize = -1L;
        private String comment;

        public Builder withHeadersSize(long headersSize) {
            this.headersSize = headersSize;
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        public Builder withCookies(List<HarCookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public Builder withHeaders(List<HarHeader> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withQueryString(List<HarQueryString> queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder withQueryString(String queryString) throws UnsupportedEncodingException {
            String[] parameters;
            ArrayList<HarQueryString> queryStrings = new ArrayList<HarQueryString>();
            for (String parameter : parameters = queryString.split("&")) {
                String value;
                int idx = parameter.indexOf("=");
                String key = idx > 0 ? URLDecoder.decode(parameter.substring(0, idx), "UTF-8") : parameter;
                String string = value = idx > 0 && parameter.length() > idx + 1 ? URLDecoder.decode(parameter.substring(idx + 1), "UTF-8") : "";
                if (key.isEmpty()) continue;
                queryStrings.add(new HarQueryString(key, value, ""));
            }
            this.queryString = queryStrings;
            return this;
        }

        public Builder withPostData(HarPostData postData) {
            this.postData = postData;
            return this;
        }

        public Builder withBodySize(long bodySize) {
            this.bodySize = bodySize;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarRequest build() {
            return new HarRequest(this.headersSize, this.method, this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.bodySize, this.comment);
        }
    }
}

