/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.xceptance.xlt.engine.har.model.HarPageTimings;
import java.util.Date;

@JsonPropertyOrder(value={"startedDateTime", "id", "title", "pageTimings", "comment"})
public class HarPage {
    private final String startedDateTime;
    private final String id;
    private final String title;
    private final HarPageTimings pageTimings;
    private final String comment;

    @JsonCreator
    public HarPage(@JsonProperty(value="startedDateTime") String startedDateTime, @JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="pageTimings") HarPageTimings pageTimings, @JsonProperty(value="comment") String comment) {
        this.startedDateTime = startedDateTime;
        this.id = id;
        this.title = title;
        this.pageTimings = pageTimings;
        this.comment = comment;
    }

    public String getStartedDateTime() {
        return this.startedDateTime;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public HarPageTimings getPageTimings() {
        return this.pageTimings;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "HarPage [id = " + this.id + ", title = " + this.title + ", pageTimings = " + this.pageTimings + ", comment = " + this.comment + ", startedDateTime = " + this.startedDateTime + "]";
    }

    public static class Builder {
        private String startedDateTime;
        private String id;
        private String title;
        private HarPageTimings pageTimings;
        private String comment;

        public Builder withStartedDateTime(Date startedDateTime) {
            this.startedDateTime = ISO8601Utils.format((Date)startedDateTime, (boolean)true);
            return this;
        }

        public Builder withStartedDateTime(String startedDateTime) {
            this.startedDateTime = startedDateTime;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withPageTimings(HarPageTimings pageTimings) {
            this.pageTimings = pageTimings;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarPage build() {
            return new HarPage(this.startedDateTime, this.id, this.title, this.pageTimings, this.comment);
        }
    }
}

