/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonPropertyOrder(value={"name", "value", "path", "domain", "expires", "httpOnly", "secure", "comment"})
public class HarCookie {
    private final String name;
    private final String value;
    private final String path;
    private final String domain;
    private final String expires;
    private final boolean httpOnly;
    private final boolean secure;
    private final String comment;

    @JsonCreator
    public HarCookie(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value, @JsonProperty(value="path") String path, @JsonProperty(value="domain") String domain, @JsonProperty(value="expires") String expires, @JsonProperty(value="httpOnly") boolean httpOnly, @JsonProperty(value="secure") boolean secure, @JsonProperty(value="comment") String comment) {
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.expires = expires;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.comment = comment;
    }

    public String getExpires() {
        return this.expires;
    }

    public String getName() {
        return this.name;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getHttpOnly() {
        return this.httpOnly;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "HarCookie [expires = " + this.expires + ", name = " + this.name + ", secure = " + this.secure + ", domain = " + this.domain + ", path = " + this.path + ", value = " + this.value + ", httpOnly = " + this.httpOnly + ", comment = " + this.comment + "]";
    }

    public static class Builder {
        private String name;
        private String value;
        private String path;
        private String domain;
        private String expires;
        private boolean httpOnly;
        private boolean secure;
        private String comment;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder withExpires(String expires) {
            this.expires = expires;
            return this;
        }

        public Builder withHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarCookie build() {
            return new HarCookie(this.name, this.value, this.path, this.domain, this.expires, this.httpOnly, this.secure, this.comment);
        }
    }
}

