/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.data;

import com.xceptance.xlt.api.data.DataSetProvider;
import com.xceptance.xlt.api.data.DataSetProviderException;
import com.xceptance.xlt.api.util.XltProperties;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class JdbcDataSetProvider
implements DataSetProvider {
    private static final String PROP_JDBC_PASSWORD = "com.xceptance.xlt.data.dataSetProviders.jdbc.password";
    private static final String PROP_JDBC_USER_NAME = "com.xceptance.xlt.data.dataSetProviders.jdbc.userName";
    private static final String PROP_JDBC_URL = "com.xceptance.xlt.data.dataSetProviders.jdbc.url";

    @Override
    public List<Map<String, String>> getAllDataSets(File dataFile) throws DataSetProviderException {
        String url = XltProperties.getInstance().getProperty(PROP_JDBC_URL, "");
        String userName = XltProperties.getInstance().getProperty(PROP_JDBC_USER_NAME, "");
        String password = XltProperties.getInstance().getProperty(PROP_JDBC_PASSWORD, "");
        if (url.length() == 0) {
            throw new DataSetProviderException("JDBC data source URL is not configured");
        }
        if (userName.length() == 0) {
            throw new DataSetProviderException("JDBC user name is not configured");
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, userName, password);
            String sqlQuery = FileUtils.readFileToString((File)dataFile, (Charset)StandardCharsets.UTF_8);
            PreparedStatement statement = connection.prepareStatement(sqlQuery);
            ResultSet resultSet = statement.executeQuery();
            ArrayList<Map<String, String>> dataSets = new ArrayList<Map<String, String>>();
            while (resultSet.next()) {
                LinkedHashMap<String, String> dataSet = new LinkedHashMap<String, String>();
                dataSets.add(dataSet);
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    String key = metaData.getColumnLabel(i);
                    String value = resultSet.getString(i);
                    dataSet.put(key, value);
                }
            }
            ArrayList<Map<String, String>> arrayList = dataSets;
            return arrayList;
        }
        catch (Exception ex) {
            throw new DataSetProviderException("Failed to retrieve data from database", ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    throw new DataSetProviderException("Failed to close database connection", ex);
                }
            }
        }
    }
}

