/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.data;

import com.xceptance.xlt.api.data.DataSetProvider;
import com.xceptance.xlt.api.data.DataSetProviderException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomXmlDataSetProvider
implements DataSetProvider {
    @Override
    public List<Map<String, String>> getAllDataSets(File dataFile) throws DataSetProviderException {
        Document document;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(dataFile));){
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(inputStream);
        }
        catch (Exception e) {
            throw new DataSetProviderException("Failed to parse XML data file: " + dataFile, e);
        }
        ArrayList<Map<String, String>> dataSets = new ArrayList<Map<String, String>>();
        Element dataSetElement = this.getFirstChildElement(document.getDocumentElement());
        while (dataSetElement != null) {
            LinkedHashMap<String, String> dataSet = new LinkedHashMap<String, String>();
            dataSets.add(dataSet);
            Element valueElement = this.getFirstChildElement(dataSetElement);
            while (valueElement != null) {
                String key = valueElement.getTagName();
                String value = valueElement.getTextContent();
                dataSet.put(key, value);
                valueElement = this.getNextSiblingElement(valueElement);
            }
            dataSetElement = this.getNextSiblingElement(dataSetElement);
        }
        return dataSets;
    }

    private Element getFirstChildElement(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    private Element getNextSiblingElement(Element element) {
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }
}

