/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.collection.ConcurrentLRUCache;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.WebConnectionWrapper;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebConnection;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;

public class CachingHttpWebConnection
extends WebConnectionWrapper {
    private static final String HEADER_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile(Pattern.quote("max-age") + "=(\\d+)");
    private final ConcurrentLRUCache<String, CacheEntry> cache;
    private final boolean useCache = XltProperties.getInstance().getProperty("com.xceptance.xlt.staticContentCache", false);

    public static long determineExpirationTime(WebResponse webResponse) {
        String expires;
        String pragma = webResponse.getResponseHeaderValue("Pragma");
        if (pragma != null && pragma.length() > 0 && pragma.contains("no-cache")) {
            return 0L;
        }
        String cacheControl = webResponse.getResponseHeaderValue("Cache-Control");
        if (cacheControl != null && cacheControl.length() > 0) {
            if (cacheControl.contains("no-cache")) {
                return 0L;
            }
            if (cacheControl.contains("must-revalidate")) {
                return 0L;
            }
            Matcher m = MAX_AGE_PATTERN.matcher(cacheControl);
            if (m.find() && m.groupCount() > 0) {
                try {
                    long maxAge = Long.parseLong(m.group(1));
                    return System.currentTimeMillis() + maxAge * 1000L;
                }
                catch (NumberFormatException maxAge) {
                    // empty catch block
                }
            }
        }
        if ((expires = webResponse.getResponseHeaderValue("Expires")) != null && expires.length() > 0) {
            if (expires.trim().equals("0")) {
                return 0L;
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(HEADER_DATE_FORMAT, Locale.ENGLISH);
            try {
                return dateParser.parse(expires).getTime();
            }
            catch (ParseException ex) {
                if (XltLogger.runTimeLogger.isWarnEnabled()) {
                    XltLogger.runTimeLogger.warn("Header Expires does not match a valid date format. Check RFC 2616. Should be a valid RFC 1123 format, such as 'Thu, 01 Dec 1994 16:00:00 GMT', but was '" + expires + "'.");
                }
                return 0L;
            }
        }
        String lastModified = webResponse.getResponseHeaderValue("Last-Modified");
        if (lastModified != null && lastModified.length() > 0) {
            SimpleDateFormat dateParser = new SimpleDateFormat(HEADER_DATE_FORMAT, Locale.ENGLISH);
            try {
                long lastModifiedTime = dateParser.parse(lastModified).getTime();
                long now = System.currentTimeMillis();
                long age = Math.max(now - lastModifiedTime, 0L);
                if (age == 0L) {
                    return 0L;
                }
                return now + age / 10L;
            }
            catch (ParseException ex) {
                if (XltLogger.runTimeLogger.isWarnEnabled()) {
                    XltLogger.runTimeLogger.warn("Header Last-Modified does not match a valid date format. Check RFC 2616. Should be a valid RFC 1123 format, such as 'Thu, 01 Dec 1994 16:00:00 GMT', but was '" + expires + "'.");
                }
                return 0L;
            }
        }
        return 0L;
    }

    public CachingHttpWebConnection(WebConnection webConnection) {
        super(webConnection);
        if (this.useCache) {
            int cacheSize = XltProperties.getInstance().getProperty("com.xceptance.xlt.staticContentCache.size", 100);
            if (cacheSize < 10) {
                XltLogger.runTimeLogger.warn("Size of static content cache is lower than minimum size of 10. Will use the minimum size.");
            }
            this.cache = new ConcurrentLRUCache(Math.max(cacheSize, 10));
        } else {
            this.cache = null;
        }
    }

    @Override
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        if (!this.useCache || !webRequest.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return this.getResponse(webRequest, null, null);
        }
        String url = webRequest.getUrl().toExternalForm();
        CacheEntry cacheEntry = this.cache.get(url);
        if (cacheEntry == null) {
            WebResponse webResponse = this.getResponse(webRequest, null, null);
            long expires = CachingHttpWebConnection.determineExpirationTime(webResponse);
            if (webResponse.getStatusCode() == 200 && expires > System.currentTimeMillis()) {
                cacheEntry = new CacheEntry();
                cacheEntry.webResponse = webResponse;
                cacheEntry.expires = expires;
                cacheEntry.lastModified = webResponse.getResponseHeaderValue("Last-Modified");
                cacheEntry.etag = webResponse.getResponseHeaderValue("ETag");
                this.cache.put(url, cacheEntry);
            }
            return webResponse;
        }
        if (cacheEntry.expires < System.currentTimeMillis()) {
            WebResponse webResponse = this.getResponse(webRequest, cacheEntry.lastModified, cacheEntry.etag);
            long expires = CachingHttpWebConnection.determineExpirationTime(webResponse);
            if (expires > System.currentTimeMillis()) {
                cacheEntry.expires = expires;
                if (webResponse.getStatusCode() == 200) {
                    cacheEntry.webResponse = webResponse;
                    cacheEntry.lastModified = webResponse.getResponseHeaderValue("Last-Modified");
                    cacheEntry.etag = webResponse.getResponseHeaderValue("ETag");
                    return webResponse;
                }
            }
            if (webResponse.getStatusCode() == 304) {
                return cacheEntry.webResponse;
            }
            this.cache.remove(url);
            return webResponse;
        }
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info("Return cached response for " + webRequest.getUrl());
        }
        return cacheEntry.webResponse;
    }

    protected WebResponse getResponse(WebRequest webRequest, String lastModifiedHeader, String etag) throws IOException {
        if (lastModifiedHeader != null && lastModifiedHeader.length() > 0) {
            webRequest.setAdditionalHeader("If-Modified-Since", lastModifiedHeader);
        }
        if (StringUtils.isNotBlank((CharSequence)etag)) {
            webRequest.setAdditionalHeader("If-None-Match", etag);
        }
        return this.getWrappedWebConnection().getResponse(webRequest);
    }

    private static class CacheEntry {
        public long expires;
        public String lastModified;
        public String etag;
        public WebResponse webResponse;

        private CacheEntry() {
        }
    }
}

