/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.WebVitalData;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.clientperformance.ClientPerformanceData;
import com.xceptance.xlt.clientperformance.ClientPerformanceRequest;
import com.xceptance.xlt.engine.util.URLCleaner;
import com.xceptance.xlt.engine.util.UrlUtils;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.FormEncodingType;
import org.htmlunit.util.NameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerformanceDataTransformator {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceDataTransformator.class);
    private final long timeDiff = GlobalClock.offset();

    public static List<ClientPerformanceData> getTransformedPerformanceDataList(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            LOG.warn("No performance data available");
            return new ArrayList<ClientPerformanceData>();
        }
        return new PerformanceDataTransformator().getPerformanceDataList(json);
    }

    private List<ClientPerformanceData> getPerformanceDataList(String json) {
        JSONArray jsonData;
        ArrayList<ClientPerformanceData> dataList = new ArrayList<ClientPerformanceData>();
        try {
            jsonData = new JSONArray(json);
        }
        catch (JSONException jsonEx) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to parse '" + json + "' as JSON array: " + jsonEx.getMessage());
            }
            return dataList;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating data entries from json data - " + jsonData);
        }
        for (int i = 0; i < jsonData.length(); ++i) {
            JSONObject timingData = jsonData.optJSONObject(i);
            if (timingData == null) continue;
            ClientPerformanceData performanceData = new ClientPerformanceData();
            JSONArray requests = timingData.optJSONArray("requests");
            if (requests != null && requests.length() > 0) {
                performanceData.getRequestList().addAll(this.getRequestList(requests));
            } else {
                LOG.warn("Entry without request");
            }
            JSONObject timings = timingData.optJSONObject("timings");
            if (timings != null) {
                performanceData.getCustomDataList().addAll(this.getCustomDataList(timings));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Entry without timings data: " + timingData);
            }
            JSONArray webVitals = timingData.optJSONArray("webVitals");
            if (webVitals != null) {
                performanceData.getWebVitalsList().addAll(this.getWebVitalsDataList(webVitals));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Entry without web-vitals data: " + timingData);
            }
            dataList.add(performanceData);
        }
        return dataList;
    }

    private List<ClientPerformanceRequest> getRequestList(JSONArray requests) {
        ArrayList<ClientPerformanceRequest> requestDataList = new ArrayList<ClientPerformanceRequest>();
        for (int requestIndex = 0; requestIndex < requests.length(); ++requestIndex) {
            JSONObject eachRequest = requests.optJSONObject(requestIndex);
            if (eachRequest == null) continue;
            try {
                ClientPerformanceRequest performanceRequest = this.buildRequest(eachRequest);
                requestDataList.add(performanceRequest);
                continue;
            }
            catch (JSONException jsonEx) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Failed to process request entry '" + eachRequest.toString() + "': " + jsonEx.getMessage());
            }
        }
        return requestDataList;
    }

    private ClientPerformanceRequest buildRequest(JSONObject requestJSON) {
        ClientPerformanceRequest performanceRequest = new ClientPerformanceRequest();
        String contentType = null;
        performanceRequest.setStatusMessage(requestJSON.optString("statusText", null));
        if (!requestJSON.isNull("header")) {
            JSONArray requestHeader = requestJSON.getJSONArray("header");
            for (NameValuePair kv : PerformanceDataTransformator.getNameValuePairs(requestHeader)) {
                if (kv.getName().toLowerCase().equals("content-type")) {
                    if (contentType != null) {
                        LOG.debug("More than one 'Content-Type' header found");
                    }
                    contentType = kv.getValue();
                }
                performanceRequest.getRequestHeaders().add(kv);
            }
        }
        if (!requestJSON.getJSONObject("response").isNull("header")) {
            JSONArray responseHeader = requestJSON.getJSONObject("response").getJSONArray("header");
            performanceRequest.getResponseHeaders().addAll(PerformanceDataTransformator.getNameValuePairs(responseHeader));
        }
        String httpMethod = requestJSON.getString("method");
        performanceRequest.setHttpMethod(httpMethod);
        JSONObject requestBodys = requestJSON.getJSONObject("body");
        if (!requestBodys.equals(JSONObject.NULL)) {
            if ("POST".equals(StringUtils.defaultString((String)httpMethod).trim().toUpperCase())) {
                String encoding = this.cleanContentType(contentType);
                String encodingLC = encoding.toLowerCase();
                if (FormEncodingType.URL_ENCODED.getName().equals(encodingLC) || FormEncodingType.MULTIPART.getName().equals(encodingLC)) {
                    performanceRequest.setFormDataEncoding(encoding);
                    JSONObject postParameters = requestBodys.optJSONObject("formData");
                    List<NameValuePair> parameterList = PerformanceDataTransformator.getNameValuePairs(postParameters);
                    performanceRequest.getFormDataParameters().addAll(parameterList);
                    performanceRequest.setFormData(UrlUtils.getUrlEncodedParameters(parameterList));
                }
            }
            performanceRequest.setRawBody(this.getRawBodyText(requestBodys.optJSONArray("raw")));
        }
        this.fillRequestData(performanceRequest, requestJSON);
        return performanceRequest;
    }

    private String getRawBodyText(JSONArray jsonArray) {
        StringBuilder sb = new StringBuilder();
        if (jsonArray != null) {
            int l = jsonArray.length();
            for (int i = 0; i < l; ++i) {
                Object text;
                JSONObject bodyPart = jsonArray.optJSONObject(i);
                if (bodyPart == null) continue;
                if (bodyPart.has("file")) {
                    text = bodyPart.optString("file");
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = "[file] " + (String)text;
                    }
                } else if (bodyPart.has("base64")) {
                    text = bodyPart.optString("base64");
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        text = "[base64] " + (String)text;
                    }
                } else {
                    text = bodyPart.optString("text");
                }
                if (text == null) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n\r\n");
                }
                sb.append((String)text);
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private void fillRequestData(ClientPerformanceRequest performanceRequest, JSONObject request) {
        RequestData requestData = performanceRequest.getRequestData();
        requestData.setName(request.getString("requestId"));
        requestData.setUrl(URLCleaner.removeUserInfoIfNecessaryAsString(request.getString("url")));
        requestData.setHttpMethod(XltCharBuffer.valueOf(performanceRequest.getHttpMethod()));
        requestData.setContentType(this.cleanContentType(request.optString("contentType")));
        int statusCode = request.optInt("statusCode", 0);
        requestData.setResponseCode(statusCode);
        requestData.setFailed(request.optBoolean("error") || statusCode == 0 || statusCode >= 500);
        requestData.setBytesReceived(request.optInt("responseSize", 0));
        requestData.setBytesSent(request.optInt("requestSize", 0));
        requestData.setTime(!request.isNull("startTime") ? request.optLong("startTime", 0L) + this.timeDiff : 0L);
        requestData.setRunTime(request.optInt("duration", 0));
        requestData.setConnectTime(request.optInt("connectTime", 0));
        requestData.setSendTime(request.optInt("sendTime", 0));
        requestData.setTimeToFirstBytes(request.optInt("firstBytesTime", 0));
        requestData.setTimeToLastBytes(request.optInt("lastBytesTime", 0));
        requestData.setReceiveTime(request.optInt("receiveTime", 0));
        requestData.setServerBusyTime(request.optInt("busyTime", 0));
        requestData.setDnsTime(request.optInt("dnsTime", 0));
        if (XltPropertiesImpl.getInstance().collectAdditonalRequestData()) {
            requestData.setFormData(XltCharBuffer.valueOf(performanceRequest.getFormData()));
            requestData.setFormDataEncoding(XltCharBuffer.valueOf(performanceRequest.getFormDataEncoding()));
        }
    }

    private String cleanContentType(String contentType) {
        return StringUtils.substringBefore((String)StringUtils.defaultString((String)contentType), (String)";").trim();
    }

    private List<PageLoadTimingData> getCustomDataList(JSONObject timings) {
        ArrayList<PageLoadTimingData> customDataList = new ArrayList<PageLoadTimingData>();
        String[] keys = JSONObject.getNames((JSONObject)timings);
        if (keys.length == 0) {
            LOG.warn("Timings data without values");
        }
        for (String eachKey : keys) {
            JSONObject timingEntry = timings.optJSONObject(eachKey);
            if (timingEntry == null) continue;
            long startTime = timingEntry.optLong("startTime", 0L);
            int runTime = timingEntry.optInt("duration", 0);
            if (startTime > 0L && runTime > 0) {
                PageLoadTimingData customData = new PageLoadTimingData();
                customData.setName(StringUtils.capitalize((String)eachKey));
                customData.setTime(startTime + this.timeDiff);
                customData.setRunTime(runTime);
                customDataList.add(customData);
                continue;
            }
            LOG.debug("Page-load timing entry for '" + eachKey + "' is incomplete and will be skipped");
        }
        return customDataList;
    }

    private List<WebVitalData> getWebVitalsDataList(JSONArray webVitalsArray) {
        ArrayList<WebVitalData> webVitalsDataList = new ArrayList<WebVitalData>();
        for (Object object : webVitalsArray) {
            if (!(object instanceof JSONObject)) continue;
            JSONObject webVital = (JSONObject)object;
            String name = webVital.optString("name", null);
            long time = webVital.optLong("time", 0L);
            Double value = webVital.optDoubleObject("value", null);
            if (name != null && time > 0L && value != null) {
                WebVitalData webVitalData = new WebVitalData();
                webVitalData.setName(name);
                webVitalData.setTime(time);
                webVitalData.setValue(value);
                webVitalsDataList.add(webVitalData);
                continue;
            }
            LOG.debug("Web-vitals entry is incomplete and will be skipped");
        }
        return webVitalsDataList;
    }

    private static List<NameValuePair> getNameValuePairs(JSONObject postParameters) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (postParameters != null) {
            String[] keys;
            for (String eachKey : keys = JSONObject.getNames((JSONObject)postParameters)) {
                JSONArray values = postParameters.getJSONArray(eachKey);
                for (int valueIndex = 0; valueIndex < values.length(); ++valueIndex) {
                    list.add(new NameValuePair(eachKey, values.getString(valueIndex)));
                }
            }
        }
        return list;
    }

    private static String getHeaderValue(JSONObject header) {
        String value = null;
        if (!header.isNull("value")) {
            value = header.getString("value");
        } else if (!header.isNull("binaryValue")) {
            value = header.get("binaryValue").toString();
        }
        return value;
    }

    private static List<NameValuePair> getNameValuePairs(JSONArray headers) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        for (int headerIndex = 0; headerIndex < headers.length(); ++headerIndex) {
            JSONObject eachHeader = headers.getJSONObject(headerIndex);
            String name = eachHeader.getString("name");
            String value = PerformanceDataTransformator.getHeaderValue(eachHeader);
            list.add(new NameValuePair(name, value));
        }
        return list;
    }

    private PerformanceDataTransformator() {
    }
}

