/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.tests;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.tests.AbstractTestCase;
import com.xceptance.xlt.engine.util.DefaultWebDriverFactory;
import org.junit.After;
import org.openqa.selenium.WebDriver;

public abstract class AbstractWebDriverTestCase
extends AbstractTestCase {
    private WebDriver webDriver;
    private boolean autoClose;

    public WebDriver getWebDriver() {
        if (this.webDriver == null) {
            this.setWebDriver(DefaultWebDriverFactory.getWebDriver());
            this.autoClose = true;
        }
        return this.webDriver;
    }

    public void setWebDriver(WebDriver webDriver) {
        ParameterCheckUtils.isNotNull(webDriver, "webDriver");
        if (this.webDriver != null) {
            throw new IllegalStateException("You may set a web driver instance only once");
        }
        this.webDriver = webDriver;
    }

    @After
    public final void __quitWebDriver() {
        if (this.autoClose && this.webDriver != null) {
            this.webDriver.quit();
        }
    }
}

