/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.util.ParameterCheckUtils;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;

public class NetworkData {
    private final WebRequest request;
    private final WebResponse response;

    public NetworkData(WebRequest request, WebResponse response) {
        ParameterCheckUtils.isNotNull(request, "request");
        this.request = request;
        this.response = response;
    }

    public HttpMethod getRequestMethod() {
        return this.request.getHttpMethod();
    }

    public String getRequestBody() {
        return this.request.getRequestBody();
    }

    public List<NameValuePair> getRequestParameters() {
        return Collections.unmodifiableList(this.request.getRequestParameters());
    }

    public Map<String, String> getAdditionalRequestHeaders() {
        return Collections.unmodifiableMap(this.request.getAdditionalHeaders());
    }

    public String getContentAsString() {
        return this.response != null ? this.response.getContentAsString() : null;
    }

    public String getContentType() {
        return this.response != null ? this.response.getContentType() : null;
    }

    public String getResponseStatusMessage() {
        return this.response != null ? this.response.getStatusMessage() : null;
    }

    public int getResponseStatusCode() {
        return this.response != null ? this.response.getStatusCode() : 0;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.response != null ? Collections.unmodifiableList(this.response.getResponseHeaders()) : Collections.emptyList();
    }

    public URL getURL() {
        return this.request.getUrl();
    }

    public WebRequest getRequest() {
        return this.request;
    }

    public WebResponse getResponse() {
        return this.response;
    }
}

