/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.actions;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.actions.AbstractWebAction;
import com.xceptance.xlt.api.htmlunit.LightWeightPage;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import java.net.URL;
import java.util.List;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.util.NameValuePair;

public abstract class AbstractLightWeightPageAction
extends AbstractWebAction {
    private LightWeightPage page;
    private URL url;

    protected AbstractLightWeightPageAction(AbstractWebAction previousAction, String timerName) {
        super(previousAction, timerName);
    }

    protected AbstractLightWeightPageAction(String timerName) {
        this(null, timerName);
    }

    @Override
    public AbstractLightWeightPageAction getPreviousAction() {
        return (AbstractLightWeightPageAction)super.getPreviousAction();
    }

    public LightWeightPage getLightWeightPage() {
        return this.page;
    }

    public String getContent() {
        LightWeightPage page = this.getLightWeightPage();
        return page != null ? page.getContent() : null;
    }

    public int getHttpResponseCode() {
        LightWeightPage page = this.getLightWeightPage();
        return page != null ? page.getHttpResponseCode() : 0;
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public void run() throws Throwable {
        try {
            super.run();
        }
        finally {
            this.dumpPage(this.getLightWeightPage());
        }
    }

    public void setLightWeightPage(LightWeightPage page) {
        ParameterCheckUtils.isNotNull(page, "page");
        this.page = page;
    }

    protected void loadPage(URL url) throws Exception {
        this.loadPage(url, HttpMethod.GET, EMPTY_PARAMETER_LIST);
    }

    protected void loadPage(String urlAsString) throws Exception {
        URL url = new URL(urlAsString);
        this.loadPage(url);
    }

    protected void loadPage(URL url, HttpMethod method, List<NameValuePair> requestParameters) throws Exception {
        WebRequest webRequest = this.createWebRequestSettings(url, method, requestParameters);
        this.url = webRequest.getUrl();
        this.setLightWeightPage(((XltWebClient)this.getWebClient()).getLightWeightPage(webRequest));
    }

    private void dumpPage(LightWeightPage page) {
        RequestHistory requestHistory = SessionImpl.getCurrent().getRequestHistory();
        if (page != null) {
            requestHistory.add(page);
        } else {
            String timerName = ((XltWebClient)this.getWebClient()).getTimerName();
            requestHistory.add(timerName);
        }
    }
}

