/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent.unipro;

import com.xceptance.xlt.agent.unipro.AbstractFunction;

public class LinearFunction
extends AbstractFunction {
    private final double m;
    private final double n;
    private final double x0;

    public LinearFunction(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2, y2);
        this.m = (y2 - y1) / (x2 - x1);
        this.n = y1 - this.m * x1;
        this.x0 = -this.n / this.m;
    }

    @Override
    public double calculateY(double x) {
        return this.m * x + this.n;
    }

    @Override
    public double calculateX2(double x1, double area) {
        double b = 2.0 * this.n;
        double a = this.m;
        double c = -(this.m * x1 * x1 + 2.0 * this.n * x1 + 2.0 * area);
        double bb_4ac = b * b - 4.0 * a * c;
        double x = bb_4ac < 0.0 ? this.x0 : (-b + Math.sqrt(bb_4ac)) / (2.0 * a);
        return Math.min(x, this.x2);
    }

    @Override
    public double integrate(double x1, double x2) {
        double dx = x2 - x1;
        double x = (x1 + x2) / 2.0;
        double y = this.calculateY(x);
        return dx * y;
    }

    public String toString() {
        return "LinearFunction: x1=" + this.x1 + " y1=" + this.y1 + " x2=" + this.x2 + " y2=" + this.y2;
    }
}

