/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.agent.AbstractExecutionTimer;
import com.xceptance.xlt.agent.unipro.CompositeFunction;
import com.xceptance.xlt.agent.unipro.Function;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.util.PriorityQueue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public class PeriodicExecutionTimer
extends AbstractExecutionTimer {
    private final ArrivalRateControllerTimerTask timerTask;
    private final Timer timer;

    public PeriodicExecutionTimer(String userTypeName, long initialDelay, long duration, int shutdownPeriod, int[][] arrivalRates, int agentIndex, double[] agentWeights) {
        super(userTypeName, initialDelay, duration, shutdownPeriod);
        this.timerTask = new ArrivalRateControllerTimerTask(arrivalRates, agentIndex, agentWeights, this, initialDelay);
        this.timer = new Timer("PeriodicExecutionTimer-" + userTypeName, true);
        this.timer.scheduleAtFixedRate((TimerTask)this.timerTask, initialDelay, 1000L);
    }

    @Override
    protected void executeWait() throws InterruptedException {
        this.timerTask.semaphore.acquire();
    }

    @Override
    public void stop() {
        this.timer.cancel();
        super.stop();
    }

    public static class AgentEntry
    implements Comparable<AgentEntry> {
        private final int agentIndex;
        private final double agentWeight;
        private int invocations;
        private int lastInvocation;
        private double weightedInvocations;

        public AgentEntry(int agentIndex, double agentWeight) {
            this.agentIndex = agentIndex;
            this.agentWeight = agentWeight;
            this.lastInvocation = 0;
        }

        @Override
        public int compareTo(AgentEntry otherAgent) {
            int result = Double.compare(this.weightedInvocations, otherAgent.weightedInvocations);
            if (result == 0 && (result = Double.compare(otherAgent.agentWeight, this.agentWeight)) == 0 && (result = Integer.valueOf(this.invocations).compareTo(otherAgent.invocations)) == 0 && (result = Integer.valueOf(this.lastInvocation).compareTo(otherAgent.lastInvocation)) == 0) {
                result = Integer.valueOf(this.agentIndex).compareTo(otherAgent.agentIndex);
            }
            return result;
        }

        public int getAgentIndex() {
            return this.agentIndex;
        }

        public double getAgentWeight() {
            return this.agentWeight;
        }

        public int getInvocations() {
            return this.invocations;
        }

        public double getWeightedInvocations() {
            return this.weightedInvocations;
        }

        public void incrementInvocations(int invocationTime) {
            ++this.invocations;
            this.weightedInvocations = (double)this.invocations / this.agentWeight;
            this.lastInvocation = invocationTime;
        }
    }

    public static class ArrivalRateControllerTimerTask
    extends TimerTask {
        private final Semaphore semaphore = new Semaphore(0, true);
        private final PeriodicExecutionTimer timer;
        private final int agentIndex;
        private final Function arrivalRateFunction;
        private final PriorityQueue<AgentEntry> agents;
        private final long startTime;
        private double lastReleaseTime = 0.0;
        private final int[] samplingPoints;
        private int startIdx;

        public ArrivalRateControllerTimerTask(int[][] arrivalRates, int agentIndex, double[] agentWeights, PeriodicExecutionTimer timer, long initialDelay) {
            int i;
            this.agentIndex = agentIndex;
            this.arrivalRateFunction = new CompositeFunction(arrivalRates);
            this.samplingPoints = new int[arrivalRates.length];
            for (i = 0; i < arrivalRates.length; ++i) {
                this.samplingPoints[i] = arrivalRates[i][0];
            }
            this.agents = new PriorityQueue();
            for (i = 0; i < agentWeights.length; ++i) {
                this.agents.add(new AgentEntry(i, agentWeights[i]));
            }
            this.timer = timer;
            this.startTime = TimerUtils.get().getStartTime();
        }

        @Override
        public void run() {
            double elapsedTimeSec = Math.round((double)TimerUtils.get().getElapsedTime(this.startTime) / 1000.0);
            int releases = this.computeReleases(elapsedTimeSec);
            int maxPermits = Math.max(releases, this.timer.getThreads().size());
            for (int i = 0; i < releases; ++i) {
                AgentEntry agentEntry = this.agents.poll();
                if (agentEntry.getAgentIndex() == this.agentIndex && this.semaphore.availablePermits() < maxPermits) {
                    this.semaphore.release();
                }
                agentEntry.incrementInvocations((int)elapsedTimeSec);
                this.agents.add(agentEntry);
            }
        }

        public int computeReleases(double elapsedTimeSec) {
            double nextSecond;
            double nextArrivalRate;
            boolean isSpecialPoint = this.isSpecialPoint(elapsedTimeSec);
            double arrivalRate = this.arrivalRateFunction.calculateY(elapsedTimeSec);
            int releases = 0;
            double period = 3600.0 / arrivalRate;
            if (elapsedTimeSec > 0.0) {
                double prevArrivalRate = this.arrivalRateFunction.calculateY(elapsedTimeSec - 1.0);
                if (prevArrivalRate > 0.0) {
                    double prevPeriod = 3600.0 / prevArrivalRate;
                    for (double nextRelease = this.lastReleaseTime + prevPeriod; nextRelease < elapsedTimeSec; nextRelease += prevPeriod) {
                        ++releases;
                        this.lastReleaseTime = nextRelease;
                    }
                }
                if (isSpecialPoint) {
                    if (this.lastReleaseTime + period <= elapsedTimeSec) {
                        ++releases;
                        this.lastReleaseTime = elapsedTimeSec;
                    }
                } else {
                    for (double nextRelease = this.lastReleaseTime + period; nextRelease <= elapsedTimeSec; nextRelease += period) {
                        ++releases;
                        this.lastReleaseTime = nextRelease;
                    }
                }
            } else if (arrivalRate > 0.0) {
                releases = 1;
                this.lastReleaseTime = elapsedTimeSec;
            }
            if (arrivalRate == 0.0 && (nextArrivalRate = this.arrivalRateFunction.calculateY(nextSecond = elapsedTimeSec + 1.0)) > 0.0) {
                double nextPeriod = 3600.0 / nextArrivalRate;
                this.lastReleaseTime = Math.max(this.lastReleaseTime, nextSecond - nextPeriod - 1.0E-6);
            }
            return releases;
        }

        private boolean isSpecialPoint(double elapsedTimeSec) {
            boolean isSpecialPoint = false;
            for (int i = this.startIdx + 1; i < this.samplingPoints.length && !((double)this.samplingPoints[i] > elapsedTimeSec); ++i) {
                this.startIdx = i;
                if ((double)this.samplingPoints[i] != elapsedTimeSec) continue;
                isSpecialPoint = true;
                break;
            }
            return isSpecialPoint;
        }
    }
}

