/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.xml;

import com.xceptance.common.util.ParameterCheckUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;

public final class XSLTUtils {
    private static final XSLTUtils instance = new XSLTUtils();
    private TransformerFactory factory = TransformerFactory.newInstance();

    private XSLTUtils() {
    }

    public static void setTransformerFactory(TransformerFactory factory) {
        if (factory != null) {
            instance.setFactory(factory);
        }
    }

    private synchronized void setFactory(TransformerFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransform(File in, File out, File styleSheet, Map<String, Object> parameters) throws FileNotFoundException, TransformerException {
        ParameterCheckUtils.isReadableFile(in, "inputXmlFile");
        ParameterCheckUtils.isReadableFile(styleSheet, "xsltStyleSheet");
        ParameterCheckUtils.isWritableFile(out, "outputFile");
        Transformer transformer = this.factory.newTransformer(new StreamSource(styleSheet));
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        FileOutputStream fos = null;
        try {
            StreamSource xmlSource = new StreamSource(in);
            fos = new FileOutputStream(out);
            StreamResult result = new StreamResult(fos);
            transformer.transform(xmlSource, result);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static void transform(File inputXmlFile, File outputFile, File xsltStyleSheet) throws FileNotFoundException, TransformerException {
        XSLTUtils.transform(inputXmlFile, outputFile, xsltStyleSheet, null);
    }

    public static void transform(File inputXmlFile, File outputFile, File xsltStyleSheet, Map<String, Object> parameters) throws FileNotFoundException, TransformerException {
        instance.doTransform(inputXmlFile, outputFile, xsltStyleSheet, parameters);
    }

    public static void tryTransform(File inputXmlFile, File outputFile, File xsltStyleSheet) {
        try {
            XSLTUtils.transform(inputXmlFile, outputFile, xsltStyleSheet);
        }
        catch (TransformerException transformerException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

