/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.xml;

import com.xceptance.common.xml.AbstractDomPrinter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HtmlDomPrinter
extends AbstractDomPrinter {
    private static final String[] EMPTY_HTML_TAGS = new String[]{"base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
    private static final String[] LITERAL_TEXT_ELEMENTS = new String[]{"style", "script", "xmp", "iframe", "noembed", "noframes", "noscript", "plaintext"};
    private boolean isXhtml;

    public HtmlDomPrinter() {
        this(-1);
    }

    public HtmlDomPrinter(int spaces) {
        super(spaces);
    }

    @Override
    public void printNode(Node node, Writer out) {
        this.isXhtml = this.isXhtml(node);
        super.printNode(node, out);
    }

    @Override
    protected void printEmptyElementClosing(Element element, PrintWriter printWriter) {
        String tagName = element.getTagName();
        if (ArrayUtils.contains((Object[])EMPTY_HTML_TAGS, (Object)tagName)) {
            if (this.isXhtml) {
                printWriter.print(" />");
            } else {
                printWriter.print(">");
            }
        } else {
            printWriter.print("></" + tagName + ">");
        }
    }

    protected boolean isXhtml(Node node) {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (document != null) {
            DocumentType documentType = document.getDoctype();
            String publicId = documentType != null ? documentType.getPublicId() : null;
            return publicId != null && publicId.toUpperCase().contains("XHTML");
        }
        return true;
    }

    private boolean needEscapeText(Node text) {
        Node node = text;
        while ((node = node.getParentNode()) != null) {
            if (node.getNodeType() != 1 || !ArrayUtils.contains((Object[])LITERAL_TEXT_ELEMENTS, (Object)((Element)node).getTagName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void printText(Text text, String indentation, PrintWriter printWriter) {
        String s = text.getData();
        if (this.needEscapeText(text)) {
            s = StringEscapeUtils.escapeXml10((String)s);
        }
        if (this.prettyPrinting) {
            if ((s = s.trim()).length() > 0) {
                printWriter.println(indentation + s);
            }
        } else {
            printWriter.print(s);
        }
    }

    @Override
    protected void printCDataSection(CDATASection cdataSection, String indentation, PrintWriter printWriter) {
        String s = cdataSection.getData();
        if (this.needEscapeText(cdataSection)) {
            s = StringEscapeUtils.escapeXml10((String)s);
        }
        printWriter.print(indentation + "<![CDATA[" + s + "]]>");
        if (this.prettyPrinting) {
            printWriter.println();
        }
    }
}

