/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ThrowableUtils {
    private static final String CUT_OFF_REGEX = "((at (sun|(java\\.base/)?jdk\\.internal)\\.reflect\\.[^\n]+?\n\t)+at (java\\.base/)?java\\.lang\\.reflect\\.[^\n]+?\n\tat org\\.junit\\.runners\\.model\\.FrameworkMethod\\$1.runReflectiveCall.+?)(Caused\\s+by|$)";
    private static final Pattern CUT_OFF_PATTERN = Pattern.compile("((at (sun|(java\\.base/)?jdk\\.internal)\\.reflect\\.[^\n]+?\n\t)+at (java\\.base/)?java\\.lang\\.reflect\\.[^\n]+?\n\tat org\\.junit\\.runners\\.model\\.FrameworkMethod\\$1.runReflectiveCall.+?)(Caused\\s+by|$)", 32);
    public static final String DIRECTORY_HINT_REGEX = " \\(user: '(.+)', output: '([0-9]+)'\\)";
    private static Field DETAIL_MESSAGE_FIELD;

    public static void setMessage(Throwable t, String message) {
        if (DETAIL_MESSAGE_FIELD != null) {
            try {
                DETAIL_MESSAGE_FIELD.set(t, message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void prefixMessage(Throwable t, String messagePrefix) {
        if (messagePrefix == null) {
            return;
        }
        String originalMessage = ThrowableUtils.getMessage(t);
        String newMessage = originalMessage == null ? messagePrefix : messagePrefix + originalMessage;
        ThrowableUtils.setMessage(t, newMessage);
    }

    private ThrowableUtils() {
    }

    public static String getMessage(Throwable t) {
        if (DETAIL_MESSAGE_FIELD != null) {
            try {
                return (String)DETAIL_MESSAGE_FIELD.get(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t.getMessage();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter(400);
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String getMinifiedStackTrace(Throwable t) {
        String tail;
        String stackTrace = ThrowableUtils.getStackTrace(t);
        int startIdx = 0;
        StringBuilder sb = new StringBuilder(1024);
        Matcher matcher = CUT_OFF_PATTERN.matcher(stackTrace);
        while (matcher.find()) {
            if (startIdx > 0) {
                sb.append(System.getProperty("line.separator", "\n"));
            }
            sb.append(stackTrace.substring(startIdx, matcher.start())).append("...");
            startIdx = matcher.end(1);
        }
        if (startIdx < stackTrace.length() && StringUtils.isNotBlank((CharSequence)(tail = stackTrace.substring(startIdx)))) {
            if (startIdx > 0) {
                sb.append(System.getProperty("line.separator", "\n"));
            }
            sb.append(tail);
        }
        return sb.toString();
    }

    static {
        try {
            DETAIL_MESSAGE_FIELD = Throwable.class.getDeclaredField("detailMessage");
            DETAIL_MESSAGE_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            DETAIL_MESSAGE_FIELD = null;
        }
    }
}

