/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.lang;

import java.util.Optional;

public final class ParseNumbers {
    private static final int DIGITOFFSET = 48;
    private static final double[] multipliers = new double[]{1.0, 1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16, 1.0E-17};

    public static long parseLong(CharSequence s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int length = s.length();
        if (length == 0) {
            throw new NumberFormatException("length = 0");
        }
        char digit = s.charAt(0);
        if (digit < '0' || digit > '9') {
            return Long.parseLong(s.toString());
        }
        long value = digit - 48;
        for (int i = 1; i < length; ++i) {
            char d = s.charAt(i);
            if (d < '0' || d > '9') {
                throw new NumberFormatException("Not a long " + s.toString());
            }
            value = (value << 3) + (value << 1);
            value += (long)(d - 48);
        }
        return value;
    }

    public static int parseInt(CharSequence s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int length = s.length();
        if (length == 0) {
            throw new NumberFormatException("length = 0");
        }
        char digit = s.charAt(0);
        if (digit < '0' || digit > '9') {
            return Integer.parseInt(s.toString());
        }
        int value = digit - 48;
        for (int i = 1; i < length; ++i) {
            char d = s.charAt(i);
            if (d < '0' || d > '9') {
                throw new NumberFormatException("Not an int " + s.toString());
            }
            value = (value << 3) + (value << 1);
            value += d - 48;
        }
        return value;
    }

    public static double parseDouble(CharSequence s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int length = s.length();
        if (length == 0) {
            throw new NumberFormatException("length = 0");
        }
        char digit = s.charAt(0);
        if (digit < '0' || digit > '9') {
            return Double.parseDouble(s.toString());
        }
        long value = digit - 48;
        int decimalPos = 0;
        for (int i = 1; i < length; ++i) {
            char d = s.charAt(i);
            if (d == '.') {
                decimalPos = i;
                continue;
            }
            if (d < '0' || d > '9') {
                throw new NumberFormatException("Not a double " + s.toString());
            }
            value = (value << 3) + (value << 1);
            value += (long)(d - 48);
        }
        return decimalPos > 0 ? (double)value * multipliers[length - decimalPos] : (double)value;
    }

    public static Optional<Integer> parseOptionalInt(String input) {
        try {
            return Optional.ofNullable(input).map(Integer::parseInt);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Long> parseOptionalLong(String input) {
        try {
            return Optional.ofNullable(input).map(Long::parseLong);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Double> parseOptionalDouble(String input) {
        try {
            return Optional.ofNullable(input).map(Double::valueOf);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

