/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.io;

import com.xceptance.xlt.api.util.XltCharBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class XltBufferedLineReader
implements Closeable {
    private Reader reader;
    private char[] buffer;
    private int bufferPos;
    private int bufferLength;
    private static final int BUFFERSIZE = 16384;
    private boolean skipNL = false;
    private boolean eof = false;

    public XltBufferedLineReader(Reader reader) {
        this.reader = reader;
        this.buffer = new char[16384];
    }

    public XltBufferedLineReader(Reader reader, int bufferSize) {
        this.reader = reader;
        this.buffer = new char[bufferSize];
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private int fill() throws IOException {
        this.bufferPos = 0;
        int read = 0;
        while ((read = this.reader.read(this.buffer)) == 0) {
        }
        this.bufferLength = read;
        return this.bufferLength;
    }

    public XltCharBuffer readLine() throws IOException {
        if (this.eof) {
            return null;
        }
        char[] sb = null;
        int lastFill = 0;
        int start = this.bufferPos;
        int sbLength = 0;
        while (true) {
            int i;
            if (this.bufferPos == this.bufferLength) {
                lastFill = this.fill();
                start = 0;
            }
            if (lastFill == -1) {
                this.eof = true;
                return sb == null ? null : new XltCharBuffer(sb, 0, sbLength);
            }
            if (this.skipNL && this.buffer[this.bufferPos] == '\n') {
                start = ++this.bufferPos;
            }
            this.skipNL = false;
            boolean eol = false;
            for (i = this.bufferPos; i < this.bufferLength; ++i) {
                char c = this.buffer[i];
                if (c > '\r') continue;
                if (c == '\r') {
                    eol = true;
                    this.skipNL = true;
                    break;
                }
                if (c != '\n') continue;
                eol = true;
                break;
            }
            this.bufferPos = i;
            int l = i - start;
            if (eol) {
                sb = XltBufferedLineReader.append(this.buffer, start, l, sb, sbLength, l);
                ++this.bufferPos;
                return new XltCharBuffer(sb, 0, sbLength += l);
            }
            if (start >= this.bufferPos) continue;
            sb = XltBufferedLineReader.append(this.buffer, start, l, sb, sbLength, 80);
            sbLength += l;
        }
    }

    private static char[] append(char[] src, int start, int length, char[] dest, int currentLength, int initialCapacity) {
        if (dest == null) {
            dest = new char[Math.max(initialCapacity, length)];
            System.arraycopy(src, start, dest, 0, length);
            return dest;
        }
        if (length > 0) {
            int newLength = currentLength + length;
            if (newLength > dest.length) {
                char[] old = dest;
                dest = new char[newLength * 2];
                System.arraycopy(old, 0, dest, 0, currentLength);
            }
            System.arraycopy(src, start, dest, currentLength, length);
        }
        return dest;
    }
}

