/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileListFileFilter
implements FileFilter {
    private static final Logger log = LoggerFactory.getLogger(FileListFileFilter.class);
    private final Set<File> allowedFiles;

    public FileListFileFilter(File[] files) {
        this.allowedFiles = new HashSet<File>(files.length);
        for (File file : files) {
            file = this.makeFileCanonical(file);
            this.allowedFiles.add(file);
        }
    }

    @Override
    public boolean accept(File file) {
        File f = this.makeFileCanonical(file);
        boolean found = this.allowedFiles.contains(f);
        if (log.isDebugEnabled()) {
            if (found) {
                log.debug("Accepting file: " + f);
            } else {
                log.debug("Ignoring file: " + f);
            }
        }
        return found;
    }

    private File makeFileCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to convert file to its canonical form: " + file, ex);
        }
    }
}

