/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.collection;

import com.xceptance.common.collection.FastHashMap;

public class LRUFastHashMap<K, V> {
    private final int capacity;
    private final int slotSize;
    private FastHashMap<K, V> m1;
    private FastHashMap<K, V> m2;
    private FastHashMap<K, V> m3;

    public LRUFastHashMap(int capacity) {
        this.capacity = capacity;
        this.slotSize = this.capacity / 3;
        this.m1 = new FastHashMap(2 * this.slotSize, 0.5f);
        this.m2 = new FastHashMap(2 * this.slotSize, 0.5f);
        this.m3 = new FastHashMap(2 * this.slotSize, 0.5f);
    }

    public V get(K key) {
        V v1 = this.m1.get(key);
        if (v1 != null) {
            return v1;
        }
        V v2 = this.m2.get(key);
        if (v2 != null) {
            this.put(key, v2);
            return v2;
        }
        V v3 = this.m3.get(key);
        if (v3 != null) {
            this.put(key, v3);
            return v3;
        }
        return null;
    }

    public V getAndNoUpdate(K key) {
        V v1 = this.m1.get(key);
        if (v1 != null) {
            return v1;
        }
        V v2 = this.m2.get(key);
        if (v2 != null) {
            return v2;
        }
        return this.m3.get(key);
    }

    public V put(K key, V value) {
        if (this.m1.size() >= this.slotSize) {
            FastHashMap<K, V> oldM3 = this.m3;
            oldM3.clear();
            this.m3 = this.m2;
            this.m2 = this.m1;
            this.m1 = oldM3;
        }
        V old = this.m1.put(key, value);
        return old;
    }

    public int size() {
        return this.m1.size() + this.m2.size() + this.m3.size();
    }
}

