/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FastHashMap<K, V> {
    private static final Object FREE_KEY = new Object();
    private static final Object REMOVED_KEY = new Object();
    private Object[] m_data;
    private final float m_fillFactor;
    private int m_threshold;
    private int m_size;
    private int m_mask;
    private int m_mask2;

    public FastHashMap() {
        this(13, 0.5f);
    }

    public FastHashMap(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = FastHashMap.arraySize(size, fillFactor);
        this.m_mask = capacity - 1;
        this.m_mask2 = capacity * 2 - 1;
        this.m_fillFactor = fillFactor;
        this.m_data = new Object[capacity * 2];
        Arrays.fill(this.m_data, FREE_KEY);
        this.m_threshold = (int)((float)capacity * fillFactor);
    }

    public V get(K key) {
        int ptr = (key.hashCode() & this.m_mask) << 1;
        Object k = this.m_data[ptr];
        if (k == FREE_KEY) {
            return null;
        }
        if (k.hashCode() == key.hashCode() && k.equals(key)) {
            return (V)this.m_data[ptr + 1];
        }
        do {
            if ((k = this.m_data[ptr = ptr + 2 & this.m_mask2]) != FREE_KEY) continue;
            return null;
        } while (k.hashCode() != key.hashCode() || !k.equals(key));
        return (V)this.m_data[ptr + 1];
    }

    public V put(K key, V value) {
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.m_data[ptr];
        if (k == FREE_KEY) {
            this.m_data[ptr] = key;
            this.m_data[ptr + 1] = value;
            if (this.m_size >= this.m_threshold) {
                this.rehash(this.m_data.length * 2);
            } else {
                ++this.m_size;
            }
            return null;
        }
        if (k.equals(key)) {
            Object ret = this.m_data[ptr + 1];
            this.m_data[ptr + 1] = value;
            return (V)ret;
        }
        int firstRemoved = -1;
        if (k == REMOVED_KEY) {
            firstRemoved = ptr;
        }
        while (true) {
            if ((k = this.m_data[ptr = ptr + 2 & this.m_mask2]) == FREE_KEY) {
                if (firstRemoved != -1) {
                    ptr = firstRemoved;
                }
                this.m_data[ptr] = key;
                this.m_data[ptr + 1] = value;
                if (this.m_size >= this.m_threshold) {
                    this.rehash(this.m_data.length * 2);
                } else {
                    ++this.m_size;
                }
                return null;
            }
            if (k.equals(key)) {
                Object ret = this.m_data[ptr + 1];
                this.m_data[ptr + 1] = value;
                return (V)ret;
            }
            if (k != REMOVED_KEY || firstRemoved != -1) continue;
            firstRemoved = ptr;
        }
    }

    public V remove(K key) {
        int ptr = this.getStartIndex(key) << 1;
        Object k = this.m_data[ptr];
        if (k == FREE_KEY) {
            return null;
        }
        if (k.equals(key)) {
            --this.m_size;
            this.m_data[ptr] = this.m_data[ptr + 2 & this.m_mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
            Object ret = this.m_data[ptr + 1];
            this.m_data[ptr + 1] = null;
            return (V)ret;
        }
        do {
            if ((k = this.m_data[ptr = ptr + 2 & this.m_mask2]) != FREE_KEY) continue;
            return null;
        } while (!k.equals(key));
        --this.m_size;
        this.m_data[ptr] = this.m_data[ptr + 2 & this.m_mask2] == FREE_KEY ? FREE_KEY : REMOVED_KEY;
        Object ret = this.m_data[ptr + 1];
        this.m_data[ptr + 1] = null;
        return (V)ret;
    }

    public int size() {
        return this.m_size;
    }

    private void rehash(int newCapacity) {
        this.m_threshold = (int)((float)(newCapacity / 2) * this.m_fillFactor);
        this.m_mask = newCapacity / 2 - 1;
        this.m_mask2 = newCapacity - 1;
        int oldCapacity = this.m_data.length;
        Object[] oldData = this.m_data;
        this.m_data = new Object[newCapacity];
        Arrays.fill(this.m_data, FREE_KEY);
        this.m_size = 0;
        for (int i = 0; i < oldCapacity; i += 2) {
            Object oldKey = oldData[i];
            if (oldKey == FREE_KEY || oldKey == REMOVED_KEY) continue;
            this.put(oldKey, oldData[i + 1]);
        }
    }

    public List<K> keys() {
        ArrayList<Object> result = new ArrayList<Object>();
        int length = this.m_data.length;
        for (int i = 0; i < length; i += 2) {
            Object o = this.m_data[i];
            if (o == FREE_KEY || o == REMOVED_KEY) continue;
            result.add(o);
        }
        return result;
    }

    public List<V> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        int length = this.m_data.length;
        for (int i = 0; i < length; i += 2) {
            Object o = this.m_data[i];
            if (o == FREE_KEY || o == REMOVED_KEY) continue;
            result.add(this.m_data[i + 1]);
        }
        return result;
    }

    public void clear() {
        this.m_size = 0;
        Arrays.fill(this.m_data, FREE_KEY);
    }

    public int getStartIndex(Object key) {
        return key.hashCode() & this.m_mask;
    }

    public static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, FastHashMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }
}

