/*
 * Copyright (c) 2005-2024 Xceptance Software Technologies GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.xceptance.xlt.engine;

import org.htmlunit.AjaxController;
import org.htmlunit.WebRequest;
import org.htmlunit.html.HtmlPage;

/**
 * Ajax controller which forces all ajax calls to be performed asynchronously.
 * 
 * @author Hartmut Arlt (Xceptance Software Technologies GmbH)
 */
public class AsynchronousAjaxController extends AjaxController
{
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean processSynchron(final HtmlPage page, final WebRequest request, final boolean async)
    {
        return false;
    }

}
