/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.Conditional;
import com.x5.template.InvalidExpressionException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CondTree {
    private static final int TEST = -1;
    private static final int NOT = 0;
    private static final int AND = 1;
    private static final int OR = 2;
    private static final String OPEN_PAREN = "(";
    private static final String CLOSE_PAREN = ")";
    private static final String NEGATOR = "!";
    private static final String OP_AND = "&&";
    private static final String OP_OR = "||";
    private int operator = -1;
    private Conditional test;
    private CondTree leftBranch;
    private CondTree rightBranch;

    public CondTree(int operator) {
        this.operator = operator;
    }

    public static CondTree buildBranch(Iterator<String> tokens) throws InvalidExpressionException {
        CondTree branch = new CondTree(-1);
        if (!tokens.hasNext()) {
            branch.test = new Conditional("");
            return branch;
        }
        while (tokens.hasNext()) {
            boolean readyForInfix;
            String token = tokens.next();
            boolean bl = readyForInfix = branch.rightBranch != null || (branch.operator == -1 || branch.operator == 0) && (branch.test != null || branch.leftBranch != null);
            if (readyForInfix) {
                if (token.equals(OPEN_PAREN) || token.equals(NEGATOR)) {
                    throw new InvalidExpressionException("Missing infix operator between expressions");
                }
                if (token.equals(OP_OR)) {
                    CondTree orNode = new CondTree(2);
                    orNode.leftBranch = branch;
                    if (branch.rightBranch != null) {
                        orNode.rightBranch = CondTree.buildBranch(tokens);
                    }
                    branch = orNode;
                    continue;
                }
                if (token.equals(OP_AND)) {
                    if (branch.operator == 2) {
                        boolean isNegated = false;
                        do {
                            if (!tokens.hasNext()) {
                                throw new InvalidExpressionException("AND operator missing right-hand-side expression");
                            }
                            token = tokens.next();
                            if (!token.equals(NEGATOR)) continue;
                            boolean bl2 = isNegated = !isNegated;
                        } while (token.equals(NEGATOR));
                        CondTree childBranch = new CondTree(1);
                        childBranch.leftBranch = branch.rightBranch;
                        branch.rightBranch = childBranch;
                        if (token.equals(OPEN_PAREN)) {
                            childBranch.rightBranch = CondTree.buildBranch(tokens);
                            continue;
                        }
                        if (token.equals(CLOSE_PAREN)) {
                            throw new InvalidExpressionException("AND operator may not be followed by close-paren");
                        }
                        childBranch.rightBranch = new CondTree(isNegated ? 0 : -1);
                        childBranch.rightBranch.test = new Conditional(token);
                        continue;
                    }
                    if (branch.operator == -1 && branch.test == null) {
                        branch.operator = 1;
                        continue;
                    }
                    CondTree andNode = new CondTree(1);
                    andNode.leftBranch = branch;
                    branch = andNode;
                    continue;
                }
            }
            if ((branch.operator == -1 || branch.operator == 0) && branch.leftBranch == null) {
                if (token.equals(OP_OR) || token.equals(OP_AND)) {
                    throw new InvalidExpressionException("Infix operator missing left-hand-side expression");
                }
                if (token.equals(OPEN_PAREN)) {
                    branch.leftBranch = CondTree.buildBranch(tokens);
                    continue;
                }
                if (token.equals(CLOSE_PAREN)) {
                    return branch;
                }
                if (token.equals(NEGATOR)) {
                    branch.operator = branch.operator == -1 ? 0 : -1;
                    continue;
                }
                branch.test = new Conditional(token);
                continue;
            }
            if (branch.leftBranch != null && branch.rightBranch == null) {
                boolean isNegated = false;
                while (token.equals(NEGATOR)) {
                    boolean bl3 = isNegated = !isNegated;
                    if (!tokens.hasNext()) {
                        throw new InvalidExpressionException("Infix operator missing right-hand-side expression");
                    }
                    token = tokens.next();
                }
                if (token.equals(OP_OR) || token.equals(OP_AND) || token.equals(CLOSE_PAREN)) {
                    throw new InvalidExpressionException("Infix operators OR/AND must be followed by expression");
                }
                if (token.equals(OPEN_PAREN)) {
                    CondTree groupedExpr = CondTree.buildBranch(tokens);
                    if (isNegated) {
                        branch.rightBranch = new CondTree(0);
                        branch.rightBranch.leftBranch = groupedExpr;
                        continue;
                    }
                    branch.rightBranch = groupedExpr;
                    continue;
                }
                CondTree childNode = new CondTree(isNegated ? 0 : -1);
                childNode.test = new Conditional(token);
                branch.rightBranch = childNode;
                continue;
            }
            if (!token.equals(CLOSE_PAREN)) continue;
            return branch;
        }
        return branch;
    }

    public String toString() {
        String prefix;
        String string = prefix = this.operator == 0 ? NEGATOR : "";
        if (this.operator == -1 || this.operator == 0) {
            if (this.leftBranch != null) {
                return prefix + OPEN_PAREN + this.leftBranch.toString() + CLOSE_PAREN;
            }
            return prefix + (this.test == null ? "NULL" : this.test.toString());
        }
        return OPEN_PAREN + this.leftBranch.toString() + ") " + (this.operator == 1 ? "AND" : "OR") + " (" + (this.rightBranch == null ? "..." : this.rightBranch.toString()) + CLOSE_PAREN;
    }

    public boolean isTrue(Chunk context) {
        if (this.operator == -1) {
            return this.leftBranch != null ? this.leftBranch.isTrue(context) : this.test.isTrue(context);
        }
        if (this.operator == 0) {
            return this.leftBranch != null ? !this.leftBranch.isTrue(context) : !this.test.isTrue(context);
        }
        if (this.operator == 1) {
            if (!this.leftBranch.isTrue(context)) {
                return false;
            }
            return this.rightBranch.isTrue(context);
        }
        if (this.operator == 2) {
            if (this.leftBranch.isTrue(context)) {
                return true;
            }
            return this.rightBranch.isTrue(context);
        }
        return false;
    }
}

