/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.ListFilter;
import com.x5.template.filters.SliceFilter;
import java.util.List;

public class PageFilter
extends ListFilter {
    public String getFilterName() {
        return "page";
    }

    public Object transformList(Chunk chunk, List list, FilterArgs arg) {
        if (list == null) {
            return list;
        }
        int page = 1;
        int pageSize = 10;
        String[] args = arg.getFilterArgs();
        if (args.length > 0) {
            page = this.resolveArg(chunk, args[0], page);
            if (args.length > 1) {
                pageSize = this.resolveArg(chunk, args[1], pageSize);
            }
        }
        int from = (page - 1) * pageSize;
        int to = page * pageSize;
        if ((from = Math.max(from, 0)) > (to = Math.min(to, list.size()))) {
            from = 0;
            to = 0;
        }
        return SliceFilter.slice(list, from, to, 1);
    }

    private int resolveArg(Chunk context, String arg, int fallback) {
        int n = fallback;
        if (arg.charAt(0) == '$' || arg.charAt(0) == '~') {
            Object obj = context.get(arg.substring(1));
            arg = obj instanceof String ? (String)obj : obj.toString();
        }
        try {
            n = Integer.parseInt(arg.trim());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return n;
    }
}

