/*
 * Decompiled with CFR 0.152.
 */
package com.x5.util;

import com.x5.util.DataCapsule;
import com.x5.util.ObjectDataMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class DataCapsuleReader {
    private static Hashtable<String, DataCapsuleReader> readerCache = new Hashtable();
    private String[] labels;
    private String[] bareLabels;
    private String[] methodNames;
    private Method[] methods;
    private Class capsuleClass;

    public static DataCapsuleReader getReader(DataCapsule[] dataCapsules) {
        DataCapsuleReader reader = DataCapsuleReader.getReaderFromCache(dataCapsules);
        if (reader == null) {
            reader = new DataCapsuleReader(dataCapsules);
            readerCache.put(reader.getDataClassName(), reader);
        }
        return reader;
    }

    public static DataCapsuleReader getReader(DataCapsule dataCapsule) {
        if (dataCapsule == null) {
            return null;
        }
        DataCapsuleReader reader = DataCapsuleReader.getReaderFromCache(dataCapsule);
        if (reader == null) {
            reader = new DataCapsuleReader(new DataCapsule[]{dataCapsule});
            readerCache.put(reader.getDataClassName(), reader);
        }
        return reader;
    }

    private static DataCapsuleReader getReaderFromCache(DataCapsule[] dataCapsules) {
        int i = 0;
        while (i < dataCapsules.length) {
            DataCapsule x = dataCapsules[i];
            if (x != null) {
                String className = x.getClass().getName();
                return readerCache.get(className);
            }
            ++i;
        }
        return null;
    }

    private static DataCapsuleReader getReaderFromCache(DataCapsule dataCapsule) {
        String className = dataCapsule.getClass().getName();
        return readerCache.get(className);
    }

    public DataCapsuleReader(DataCapsule[] dataCapsules) {
        this.extractLegend(dataCapsules);
    }

    private void extractLegend(DataCapsule[] dataCapsules) {
        int i = 0;
        while (i < dataCapsules.length) {
            DataCapsule x = dataCapsules[i];
            if (x != null) {
                this.capsuleClass = x.getClass();
                this.extractLegend(x);
                break;
            }
            ++i;
        }
    }

    private void extractLegend(DataCapsule dataCapsule) {
        String[] exports = dataCapsule.getExports();
        String exportPrefix = dataCapsule.getExportPrefix();
        this.labels = new String[exports.length];
        this.bareLabels = new String[exports.length];
        this.methodNames = new String[exports.length];
        int i = 0;
        while (i < exports.length) {
            this.parseExportMap(i, exportPrefix, exports[i]);
            ++i;
        }
    }

    private void parseExportMap(int i, String exportPrefix, String directive) {
        String methodName;
        int spacePos = directive.indexOf(32);
        String exportName = directive;
        if (spacePos > -1) {
            exportName = directive.substring(spacePos + 1).trim();
            methodName = directive.substring(0, spacePos);
        } else {
            methodName = directive;
            exportName = DataCapsuleReader.transmogrify(directive);
        }
        String prefixedName = exportName;
        if (exportPrefix != null) {
            prefixedName = String.valueOf(exportPrefix) + "_" + exportName;
        }
        this.labels[i] = prefixedName;
        this.bareLabels[i] = exportName;
        this.methodNames[i] = methodName;
    }

    private static String transmogrify(String s) {
        String spaced = ObjectDataMap.splitCamelCase(s);
        if (spaced.startsWith("get_")) {
            return spaced.substring(4);
        }
        return spaced;
    }

    public String[] getColumnLabels(String altPrefix) {
        if (altPrefix == null) {
            return this.getColumnLabels();
        }
        String[] altLabels = new String[this.bareLabels.length];
        int i = 0;
        while (i < altLabels.length) {
            altLabels[i] = String.valueOf(altPrefix) + "." + this.labels[i];
            ++i;
        }
        return altLabels;
    }

    public String[] getColumnLabels() {
        return this.labels;
    }

    public void overrideColumnLabels(String[] newLabels) {
        this.labels = newLabels;
    }

    public Object[] extractData(DataCapsule data) {
        if (this.methods == null) {
            this.methods = this.grokMethods(data);
        }
        Object[] rawOutput = new Object[this.methods.length];
        int i = 0;
        while (i < this.methods.length) {
            Method m = this.methods[i];
            if (m != null) {
                try {
                    rawOutput[i] = m.invoke((Object)data, null);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.err);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace(System.err);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace(System.err);
                }
            }
            ++i;
        }
        return rawOutput;
    }

    public String getDataClassName() {
        return this.capsuleClass.getName();
    }

    private Method[] grokMethods(DataCapsule data) {
        Method[] methods = new Method[this.methodNames.length];
        int i = 0;
        while (i < methods.length) {
            try {
                methods[i] = this.capsuleClass.getMethod(this.methodNames[i], null);
            }
            catch (NoSuchMethodException e) {
                System.err.println("Class " + this.capsuleClass.getName() + " does not provide method " + this.methodNames[i] + "() as described in getExports() !!");
                e.printStackTrace(System.err);
            }
            ++i;
        }
        return methods;
    }

    private Method[] grokSimpleMethods(DataCapsule data) {
        Method[] allMethods = this.capsuleClass.getMethods();
        boolean[] isMatch = new boolean[allMethods.length];
        int matchCount = 0;
        int i = 0;
        while (i < allMethods.length) {
            Method m = allMethods[i];
            if (m.getReturnType() == String.class && m.getParameterTypes() == null) {
                String simpleMethodName = m.getName();
                isMatch[i] = true;
                ++matchCount;
            }
            ++i;
        }
        Method[] simpleMethods = new Method[matchCount];
        int i2 = allMethods.length - 1;
        while (i2 >= 0 && matchCount > 0) {
            if (isMatch[i2]) {
                simpleMethods[--matchCount] = allMethods[i2];
            }
            --i2;
        }
        return simpleMethods;
    }
}

