/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.ChunkLocale;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.FilterArgs;
import java.util.IllegalFormatException;
import java.util.Locale;

public class FormatFilter
extends BasicFilter {
    public String transformText(Chunk chunk, String text, FilterArgs arg) {
        if (text == null) {
            return null;
        }
        String fmtString = arg.getUnparsedArgs();
        if (fmtString == null) {
            return "";
        }
        ChunkLocale locale = null;
        if (chunk != null) {
            locale = chunk.getLocale();
        }
        return FormatFilter.applyFormatString(text, fmtString, locale);
    }

    public String getFilterName() {
        return "sprintf";
    }

    private static String applyFormatString(String text, String formatString, ChunkLocale locale) {
        char last;
        char first;
        if (formatString.startsWith("sprintf(") && (formatString = formatString.substring(8)).endsWith(")")) {
            formatString = formatString.substring(0, formatString.length() - 1);
        }
        if ((first = formatString.charAt(0)) == (last = formatString.charAt(formatString.length() - 1)) && (first == '\'' || first == '\"')) {
            formatString = formatString.substring(1, formatString.length() - 1);
        }
        return FormatFilter.formatNumberFromString(formatString, text, locale);
    }

    public static String formatNumberFromString(String formatString, String value) {
        return FormatFilter.formatNumberFromString(formatString, value, null);
    }

    public static Locale getJavaLocale(ChunkLocale locale) {
        if (locale == null) {
            return null;
        }
        return locale.getJavaLocale();
    }

    public static String formatNumberFromString(String formatString, String value, ChunkLocale chunkLocale) {
        char expecting = formatString.charAt(formatString.length() - 1);
        try {
            Locale locale = FormatFilter.getJavaLocale(chunkLocale);
            if ("sS".indexOf(expecting) > -1) {
                return String.format(locale, formatString, value);
            }
            if ("eEfgGaA".indexOf(expecting) > -1) {
                float f = Float.valueOf(value).floatValue();
                return String.format(locale, formatString, Float.valueOf(f));
            }
            if ("doxX".indexOf(expecting) > -1) {
                if (value.trim().startsWith("#")) {
                    long l = Long.parseLong(value.trim().substring(1), 16);
                    return String.format(locale, formatString, l);
                }
                if (value.trim().startsWith("0X") || value.trim().startsWith("0x")) {
                    long l = Long.parseLong(value.trim().substring(2), 16);
                    return String.format(locale, formatString, l);
                }
                float f = Float.valueOf(value).floatValue();
                return String.format(locale, formatString, (long)f);
            }
            if ("cC".indexOf(expecting) > -1) {
                if (value.trim().startsWith("0X") || value.trim().startsWith("0x")) {
                    int i = Integer.parseInt(value.trim().substring(2), 16);
                    return String.format(locale, formatString, Character.valueOf((char)i));
                }
                float f = Float.valueOf(value).floatValue();
                return String.format(locale, formatString, Character.valueOf((char)f));
            }
            return "[Unknown format " + expecting + ": \"" + formatString + "\"," + value + "]";
        }
        catch (NumberFormatException e) {
            return value;
        }
        catch (IllegalFormatException e) {
            return "[" + e.getClass().getName() + ": " + e.getMessage() + " \"" + formatString + "\"," + value + "]";
        }
    }
}

