/*
 * Decompiled with CFR 0.152.
 */
package com.x5.util;

import com.x5.util.DataCapsule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class DataCapsuleReader {
    private static Hashtable<String, DataCapsuleReader> readerCache = new Hashtable();
    private String[] labels;
    private String[] bareLabels;
    private String[] methodNames;
    private Method[] methods;
    private Class capsuleClass;

    public static DataCapsuleReader getReader(DataCapsule[] dataCapsules) {
        DataCapsuleReader reader = DataCapsuleReader.getReaderFromCache(dataCapsules);
        if (reader == null) {
            reader = new DataCapsuleReader(dataCapsules);
            readerCache.put(reader.getDataClassName(), reader);
        }
        return reader;
    }

    public static DataCapsuleReader getReader(DataCapsule dataCapsule) {
        if (dataCapsule == null) {
            return null;
        }
        DataCapsuleReader reader = DataCapsuleReader.getReaderFromCache(dataCapsule);
        if (reader == null) {
            reader = new DataCapsuleReader(new DataCapsule[]{dataCapsule});
            readerCache.put(reader.getDataClassName(), reader);
        }
        return reader;
    }

    private static DataCapsuleReader getReaderFromCache(DataCapsule[] dataCapsules) {
        for (int i = 0; i < dataCapsules.length; ++i) {
            DataCapsule x = dataCapsules[i];
            if (x == null) continue;
            String className = x.getClass().getName();
            return readerCache.get(className);
        }
        return null;
    }

    private static DataCapsuleReader getReaderFromCache(DataCapsule dataCapsule) {
        String className = dataCapsule.getClass().getName();
        return readerCache.get(className);
    }

    public DataCapsuleReader(DataCapsule[] dataCapsules) {
        this.extractLegend(dataCapsules);
    }

    private void extractLegend(DataCapsule[] dataCapsules) {
        for (int i = 0; i < dataCapsules.length; ++i) {
            DataCapsule x = dataCapsules[i];
            if (x == null) continue;
            this.capsuleClass = x.getClass();
            this.extractLegend(x);
            break;
        }
    }

    private void extractLegend(DataCapsule dataCapsule) {
        String[] exports = dataCapsule.getExports();
        String exportPrefix = dataCapsule.getExportPrefix();
        this.labels = new String[exports.length];
        this.bareLabels = new String[exports.length];
        this.methodNames = new String[exports.length];
        for (int i = 0; i < exports.length; ++i) {
            this.parseExportMap(i, exportPrefix, exports[i]);
        }
    }

    private void parseExportMap(int i, String exportPrefix, String directive) {
        String methodName;
        int spacePos = directive.indexOf(32);
        String exportName = directive;
        if (spacePos > -1) {
            exportName = directive.substring(spacePos + 1).trim();
            methodName = directive.substring(0, spacePos);
        } else {
            methodName = directive;
            exportName = DataCapsuleReader.transmogrify(directive);
        }
        String prefixedName = exportName;
        if (exportPrefix != null) {
            prefixedName = exportPrefix + "_" + exportName;
        }
        this.labels[i] = prefixedName;
        this.bareLabels[i] = exportName;
        this.methodNames[i] = methodName;
    }

    private static String transmogrify(String s) {
        String spaced = DataCapsuleReader.splitCamelCase(s);
        return spaced.toLowerCase().replaceFirst("^get_", "");
    }

    private static String splitCamelCase(String s) {
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_");
    }

    public String[] getColumnLabels(String altPrefix) {
        if (altPrefix == null) {
            return this.getColumnLabels();
        }
        String[] altLabels = new String[this.bareLabels.length];
        for (int i = 0; i < altLabels.length; ++i) {
            altLabels[i] = altPrefix + "." + this.labels[i];
        }
        return altLabels;
    }

    public String[] getColumnLabels() {
        return this.labels;
    }

    public void overrideColumnLabels(String[] newLabels) {
        this.labels = newLabels;
    }

    public Object[] extractData(DataCapsule data) {
        if (this.methods == null) {
            this.methods = this.grokMethods(data);
        }
        Object[] rawOutput = new Object[this.methods.length];
        for (int i = 0; i < this.methods.length; ++i) {
            Method m = this.methods[i];
            if (m == null) continue;
            try {
                rawOutput[i] = m.invoke((Object)data, (Object[])null);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace(System.err);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(System.err);
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace(System.err);
            }
        }
        return rawOutput;
    }

    public String getDataClassName() {
        return this.capsuleClass.getName();
    }

    private Method[] grokMethods(DataCapsule data) {
        Method[] methods = new Method[this.methodNames.length];
        for (int i = 0; i < methods.length; ++i) {
            try {
                methods[i] = this.capsuleClass.getMethod(this.methodNames[i], null);
                continue;
            }
            catch (NoSuchMethodException e) {
                System.err.println("Class " + this.capsuleClass.getName() + " does not provide method " + this.methodNames[i] + "() as described in getExports() !!");
                e.printStackTrace(System.err);
            }
        }
        return methods;
    }

    private Method[] grokSimpleMethods(DataCapsule data) {
        Method[] allMethods = this.capsuleClass.getMethods();
        boolean[] isMatch = new boolean[allMethods.length];
        int matchCount = 0;
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (m.getReturnType() != String.class || m.getParameterTypes() != null) continue;
            String simpleMethodName = m.getName();
            isMatch[i] = true;
            ++matchCount;
        }
        Method[] simpleMethods = new Method[matchCount];
        for (int i = allMethods.length - 1; i >= 0 && matchCount > 0; --i) {
            if (!isMatch[i]) continue;
            simpleMethods[--matchCount] = allMethods[i];
        }
        return simpleMethods;
    }
}

