/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.tokens;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CreateTokenRequest;
import com.onlinepayments.domain.CreatedTokenResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.TokenResponse;
import com.onlinepayments.merchant.tokens.TokensClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class TokensClient
extends ApiResource
implements TokensClientInterface {
    public TokensClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CreatedTokenResponse createToken(CreateTokenRequest body) {
        return this.createToken(body, null);
    }

    @Override
    public CreatedTokenResponse createToken(CreateTokenRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/tokens", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CreatedTokenResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public TokenResponse getToken(String tokenId) {
        return this.getToken(tokenId, null);
    }

    @Override
    public TokenResponse getToken(String tokenId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("tokenId", tokenId);
        String uri = this.instantiateUri("/v2/{merchantId}/tokens/{tokenId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, TokenResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public void deleteToken(String tokenId) {
        this.deleteToken(tokenId, null);
    }

    @Override
    public void deleteToken(String tokenId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("tokenId", tokenId);
        String uri = this.instantiateUri("/v2/{merchantId}/tokens/{tokenId}", pathContext);
        try {
            this.communicator.delete(uri, this.getClientHeaders(), null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

