/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.payments;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ResponseException;
import com.onlinepayments.domain.CancelPaymentRequest;
import com.onlinepayments.domain.CancelPaymentResponse;
import com.onlinepayments.domain.CapturePaymentRequest;
import com.onlinepayments.domain.CaptureResponse;
import com.onlinepayments.domain.CapturesResponse;
import com.onlinepayments.domain.CompletePaymentRequest;
import com.onlinepayments.domain.CompletePaymentResponse;
import com.onlinepayments.domain.CreatePaymentRequest;
import com.onlinepayments.domain.CreatePaymentResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.PaymentDetailsResponse;
import com.onlinepayments.domain.PaymentErrorResponse;
import com.onlinepayments.domain.PaymentResponse;
import com.onlinepayments.domain.RefundErrorResponse;
import com.onlinepayments.domain.RefundRequest;
import com.onlinepayments.domain.RefundResponse;
import com.onlinepayments.domain.RefundsResponse;
import com.onlinepayments.domain.SubsequentPaymentRequest;
import com.onlinepayments.domain.SubsequentPaymentResponse;
import com.onlinepayments.merchant.payments.PaymentsClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class PaymentsClient
extends ApiResource
implements PaymentsClientInterface {
    public PaymentsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CreatePaymentResponse createPayment(CreatePaymentRequest body) {
        return this.createPayment(body, null);
    }

    @Override
    public CreatePaymentResponse createPayment(CreatePaymentRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/payments", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CreatePaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentResponse getPayment(String paymentId) {
        return this.getPayment(paymentId, null);
    }

    @Override
    public PaymentResponse getPayment(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CompletePaymentResponse completePayment(String paymentId, CompletePaymentRequest body) {
        return this.completePayment(paymentId, body, null);
    }

    @Override
    public CompletePaymentResponse completePayment(String paymentId, CompletePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/complete", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CompletePaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId) {
        CancelPaymentRequest body = null;
        return this.cancelPayment(paymentId, body, null);
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId, CallContext context) {
        CancelPaymentRequest body = null;
        return this.cancelPayment(paymentId, body, context);
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId, CancelPaymentRequest body) {
        return this.cancelPayment(paymentId, body, null);
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId, CancelPaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/cancel", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CancelPaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public SubsequentPaymentResponse subsequentPayment(String paymentId, SubsequentPaymentRequest body) {
        return this.subsequentPayment(paymentId, body, null);
    }

    @Override
    public SubsequentPaymentResponse subsequentPayment(String paymentId, SubsequentPaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/subsequent", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, SubsequentPaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public RefundResponse refundPayment(String paymentId, RefundRequest body) {
        return this.refundPayment(paymentId, body, null);
    }

    @Override
    public RefundResponse refundPayment(String paymentId, RefundRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/refund", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, RefundResponse.class, context);
        }
        catch (ResponseException e) {
            Class<RefundErrorResponse> errorType = RefundErrorResponse.class;
            RefundErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CaptureResponse capturePayment(String paymentId, CapturePaymentRequest body) {
        return this.capturePayment(paymentId, body, null);
    }

    @Override
    public CaptureResponse capturePayment(String paymentId, CapturePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/capture", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, body, CaptureResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CapturesResponse getCaptures(String paymentId) {
        return this.getCaptures(paymentId, null);
    }

    @Override
    public CapturesResponse getCaptures(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/captures", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, CapturesResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentDetailsResponse getPaymentDetails(String paymentId) {
        return this.getPaymentDetails(paymentId, null);
    }

    @Override
    public PaymentDetailsResponse getPaymentDetails(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/details", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PaymentDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public RefundsResponse getRefunds(String paymentId) {
        return this.getRefunds(paymentId, null);
    }

    @Override
    public RefundsResponse getRefunds(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/refunds", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, RefundsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw this.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

