/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.Obfuscator;
import com.onlinepayments.logging.ValueObfuscator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PropertyObfuscator
extends Obfuscator {
    private final Pattern propertyPattern;

    PropertyObfuscator(Map<String, ValueObfuscator> obfuscators) {
        super(obfuscators, false);
        this.propertyPattern = this.buildPropertyPattern(obfuscators.keySet());
    }

    private Pattern buildPropertyPattern(Set<String> propertyNames) {
        if (propertyNames.isEmpty()) {
            return Pattern.compile("$^");
        }
        Iterator<String> iterator = propertyNames.iterator();
        StringBuilder regex = new StringBuilder();
        regex.append("([\"'])(");
        regex.append(Pattern.quote(iterator.next()));
        while (iterator.hasNext()) {
            regex.append('|').append(Pattern.quote(iterator.next()));
        }
        regex.append(")\\1\\s*:\\s*(?:([\"'])(.*?)(?<!\\\\)\\3|([^\"'\\s\\[\\{]\\S*))");
        int flags = 32;
        return Pattern.compile(regex.toString(), 32);
    }

    String obfuscate(CharSequence body) {
        if (body == null) {
            return null;
        }
        if (body.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(body.length());
        int index = 0;
        Matcher matcher = this.propertyPattern.matcher(body);
        while (matcher.find()) {
            String propertyName = matcher.group(2);
            String value = matcher.group(4);
            int valueStart = matcher.start(4);
            int valueEnd = matcher.end(4);
            if (value == null) {
                value = matcher.group(5);
                valueStart = matcher.start(5);
                valueEnd = matcher.end(5);
            }
            String obfuscatedValue = this.obfuscateValue(propertyName, value);
            sb.append(body, index, valueStart);
            sb.append(obfuscatedValue);
            index = valueEnd;
        }
        sb.append(body, index, body.length());
        return sb.toString();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends Obfuscator.Builder {
        Builder() {
        }

        @Override
        Builder withField(String property) {
            super.withField(property);
            return this;
        }

        @Override
        Builder withSensitiveField(String property) {
            super.withSensitiveField(property);
            return this;
        }

        @Override
        PropertyObfuscator build() {
            return new PropertyObfuscator(this.getObfuscators());
        }
    }
}

