/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.dartsclone;

import com.worksap.nlp.dartsclone.details.DoubleArrayBuilder;
import com.worksap.nlp.dartsclone.details.KeySet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;

public class DoubleArray {
    private IntBuffer array;
    private ByteBuffer buffer;
    private int size;

    public void setArray(IntBuffer array, int size) {
        this.array = array;
        this.size = size;
    }

    public IntBuffer array() {
        return this.array;
    }

    public ByteBuffer byteArray() {
        return this.buffer;
    }

    public void clear() {
        this.buffer = null;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int totalSize() {
        return 4 * this.size;
    }

    public void build(byte[][] keys, int[] values, BiConsumer<Integer, Integer> progressFunction) {
        KeySet keySet = new KeySet(keys, values);
        DoubleArrayBuilder builder = new DoubleArrayBuilder(progressFunction);
        builder.build(keySet);
        this.buffer = builder.copy();
        this.array = this.buffer.asIntBuffer();
        this.size = this.array.capacity();
    }

    public void open(FileChannel inputFile, long position, long totalSize) throws IOException {
        if (position < 0L) {
            position = 0L;
        }
        if (totalSize <= 0L) {
            totalSize = inputFile.size();
        }
        this.buffer = inputFile.map(FileChannel.MapMode.READ_ONLY, position, totalSize);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.array = this.buffer.asIntBuffer();
        this.size = this.array.capacity();
    }

    public void save(FileChannel outputFile) throws IOException {
        outputFile.write(this.buffer);
    }

    public int[] exactMatchSearch(byte[] key) {
        int[] result = new int[]{-1, 0};
        int nodePos = 0;
        int unit = this.array.get(nodePos);
        for (byte k : key) {
            if (this.label(unit = this.array.get(nodePos ^= this.offset(unit) ^ Byte.toUnsignedInt(k))) == Byte.toUnsignedInt(k)) continue;
            return result;
        }
        if (!this.hasLeaf(unit)) {
            return result;
        }
        unit = this.array.get(nodePos ^ this.offset(unit));
        result[0] = this.value(unit);
        result[1] = key.length;
        return result;
    }

    public List<int[]> commonPrefixSearch(byte[] key, int offset, int maxNumResult) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int nodePos = 0;
        int unit = this.array.get(nodePos);
        nodePos ^= this.offset(unit);
        for (int i = offset; i < key.length; ++i) {
            byte k = key[i];
            unit = this.array.get(nodePos ^= Byte.toUnsignedInt(k));
            if (this.label(unit) != Byte.toUnsignedInt(k)) {
                return result;
            }
            nodePos ^= this.offset(unit);
            if (!this.hasLeaf(unit) || result.size() >= maxNumResult) continue;
            int[] r = new int[]{this.value(this.array.get(nodePos)), i + 1};
            result.add(r);
        }
        return result;
    }

    public Iterator<int[]> commonPrefixSearch(byte[] key, int offset) {
        return new Itr(key, offset);
    }

    private boolean hasLeaf(int unit) {
        return (unit >>> 8 & 1) == 1;
    }

    private int value(int unit) {
        return unit & Integer.MAX_VALUE;
    }

    private int label(int unit) {
        return unit & 0x800000FF;
    }

    private int offset(int unit) {
        return unit >>> 10 << ((unit & 0x200) >>> 6);
    }

    private class Itr
    implements Iterator<int[]> {
        private final byte[] key;
        private int offset;
        private int nodePos;
        private int[] next;

        Itr(byte[] key, int offset) {
            this.key = key;
            this.offset = offset;
            this.nodePos = 0;
            int unit = DoubleArray.this.array.get(this.nodePos);
            this.nodePos ^= DoubleArray.this.offset(unit);
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public int[] next() {
            int[] r = this.next != null ? this.next : this.getNext();
            this.next = null;
            if (r == null) {
                throw new NoSuchElementException();
            }
            return r;
        }

        int[] getNext() {
            while (this.offset < this.key.length) {
                byte k = this.key[this.offset];
                this.nodePos ^= Byte.toUnsignedInt(k);
                int unit = DoubleArray.this.array.get(this.nodePos);
                if (DoubleArray.this.label(unit) != Byte.toUnsignedInt(k)) {
                    this.offset = this.key.length;
                    return null;
                }
                this.nodePos ^= DoubleArray.this.offset(unit);
                if (DoubleArray.this.hasLeaf(unit)) {
                    int[] r = new int[]{DoubleArray.this.value(DoubleArray.this.array.get(this.nodePos)), ++this.offset};
                    return r;
                }
                ++this.offset;
            }
            return null;
        }
    }
}

