/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.view;

import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import com.wlf.camerakit.kit.CameraKit;
import com.wlf.camerakit.listener.CameraListener;
import com.wlf.camerakit.utils.AspectRatio;
import com.wlf.camerakit.utils.CameraImpl;
import com.wlf.camerakit.utils.ConstantMapper;
import com.wlf.camerakit.utils.PreviewImpl;
import com.wlf.camerakit.utils.ProcessStillTask;
import com.wlf.camerakit.utils.Size;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class Camera1
extends CameraImpl {
    private static final int FOCUS_AREA_SIZE_DEFAULT = 300;
    private static final int FOCUS_METERING_AREA_WEIGHT_DEFAULT = 1000;
    private static final int DELAY_MILLIS_BEFORE_RESETTING_FOCUS = 3000;
    private int mCameraId;
    public Camera mCamera;
    private Camera.Parameters mCameraParameters;
    private Camera.CameraInfo mCameraInfo;
    private Size mPreviewSize;
    private Size mCaptureSize;
    private MediaRecorder mMediaRecorder;
    private File mVideoFile;
    private Camera.AutoFocusCallback mAutofocusCallback;
    private int mDisplayOrientation;
    private int mFacing;
    private int mFlash;
    private int mFocus;
    private int mMethod;
    private int mZoom;
    private int mVideoQuality;
    private Handler mHandler = new Handler();

    public Camera1(CameraListener callback, PreviewImpl preview) {
        super(callback, preview);
        preview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
                if (Camera1.this.mCamera != null) {
                    Camera1.this.setupPreview();
                    Camera1.this.adjustCameraParameters();
                }
            }
        });
        this.mCameraInfo = new Camera.CameraInfo();
    }

    @Override
    public void start() {
        this.setFacing(this.mFacing);
        this.openCamera();
        if (this.mPreview.isReady()) {
            this.setupPreview();
        }
        this.mCamera.startPreview();
    }

    @Override
    public void stop() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
        }
        this.mHandler.removeCallbacksAndMessages(null);
        this.releaseCamera();
    }

    @Override
    public void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
    }

    @Override
    public void setFacing(int facing) {
        int internalFacing = new ConstantMapper.Facing(facing).map();
        if (internalFacing == -1) {
            return;
        }
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mCameraInfo);
            if (this.mCameraInfo.facing != internalFacing) continue;
            this.mCameraId = i;
            this.mFacing = facing;
            break;
        }
        if (this.mFacing == facing && this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    public void setFlash(int flash) {
        if (this.mCameraParameters != null) {
            List flashes = this.mCameraParameters.getSupportedFlashModes();
            String internalFlash = new ConstantMapper.Flash(flash).map();
            if (flashes != null && flashes.contains(internalFlash)) {
                this.mCameraParameters.setFlashMode(internalFlash);
                this.mFlash = flash;
            } else {
                String currentFlash = new ConstantMapper.Flash(this.mFlash).map();
                if (flashes == null || !flashes.contains(currentFlash)) {
                    this.mCameraParameters.setFlashMode("off");
                    this.mFlash = 0;
                }
            }
            this.mCamera.setParameters(this.mCameraParameters);
        } else {
            this.mFlash = flash;
        }
    }

    @Override
    public void setFocus(int focus) {
        this.mFocus = focus;
        switch (focus) {
            case 1: {
                if (this.mCameraParameters == null) break;
                this.detachFocusTapListener();
                List modes = this.mCameraParameters.getSupportedFocusModes();
                if (modes.contains("continuous-picture")) {
                    this.mCameraParameters.setFocusMode("continuous-picture");
                    break;
                }
                this.setFocus(0);
                break;
            }
            case 2: {
                if (this.mCameraParameters == null) break;
                this.attachFocusTapListener();
                List modes = this.mCameraParameters.getSupportedFocusModes();
                if (!modes.contains("continuous-picture")) break;
                this.mCameraParameters.setFocusMode("continuous-picture");
                break;
            }
            case 0: {
                if (this.mCameraParameters == null) break;
                this.detachFocusTapListener();
                List modes = this.mCameraParameters.getSupportedFocusModes();
                if (modes.contains("fixed")) {
                    this.mCameraParameters.setFocusMode("fixed");
                    break;
                }
                if (modes.contains("infinity")) {
                    this.mCameraParameters.setFocusMode("infinity");
                    break;
                }
                this.mCameraParameters.setFocusMode("auto");
            }
        }
    }

    @Override
    public void setMethod(int method) {
        this.mMethod = method;
    }

    @Override
    public void setZoom(int zoom) {
        this.mZoom = zoom;
    }

    @Override
    public void setVideoQuality(int videoQuality) {
        this.mVideoQuality = videoQuality;
    }

    @Override
    public void captureImage() {
        switch (this.mMethod) {
            case 0: {
                this.mCamera.takePicture(null, null, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        Camera1.this.mCameraListener.onPictureTaken(data);
                        camera.startPreview();
                    }
                });
                break;
            }
            case 1: {
                this.mCamera.setOneShotPreviewCallback(new Camera.PreviewCallback(){

                    public void onPreviewFrame(byte[] data, Camera camera) {
                        new Thread(new ProcessStillTask(data, camera, Camera1.this.calculateCaptureRotation(), new ProcessStillTask.OnStillProcessedListener(){

                            @Override
                            public void onStillProcessed(YuvImage yuv) {
                                Camera1.this.mCameraListener.onPictureTaken(yuv);
                            }
                        })).start();
                    }
                });
            }
        }
    }

    @Override
    public void startVideo() {
        this.initMediaRecorder();
        this.prepareMediaRecorder();
        this.mMediaRecorder.start();
    }

    @Override
    public void endVideo() {
        this.mMediaRecorder.stop();
        this.mMediaRecorder.release();
        this.mMediaRecorder = null;
        this.mCameraListener.onVideoTaken(this.mVideoFile);
    }

    @Override
    public Size getCaptureResolution() {
        if (this.mCaptureSize == null && this.mCameraParameters != null) {
            TreeSet<Size> sizes = new TreeSet<Size>();
            for (Camera.Size size : this.mCameraParameters.getSupportedPictureSizes()) {
                sizes.add(new Size(size.width, size.height));
            }
            TreeSet<AspectRatio> aspectRatios = this.findCommonAspectRatios(this.mCameraParameters.getSupportedPreviewSizes(), this.mCameraParameters.getSupportedPictureSizes());
            AspectRatio targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mCaptureSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mCaptureSize = size;
                break;
            }
        }
        return this.mCaptureSize;
    }

    @Override
    public Size getPreviewResolution() {
        if (this.mPreviewSize == null && this.mCameraParameters != null) {
            TreeSet<Size> sizes = new TreeSet<Size>();
            for (Camera.Size size : this.mCameraParameters.getSupportedPreviewSizes()) {
                sizes.add(new Size(size.width, size.height));
            }
            TreeSet<AspectRatio> aspectRatios = this.findCommonAspectRatios(this.mCameraParameters.getSupportedPreviewSizes(), this.mCameraParameters.getSupportedPictureSizes());
            AspectRatio targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mPreviewSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mPreviewSize = size;
                break;
            }
        }
        return this.mPreviewSize;
    }

    @Override
    public boolean isCameraOpened() {
        return this.mCamera != null;
    }

    private void openCamera() {
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        this.mCamera = Camera.open((int)this.mCameraId);
        this.mCameraParameters = this.mCamera.getParameters();
        this.adjustCameraParameters();
        this.mCamera.setDisplayOrientation(this.calculatePreviewRotation());
        this.mCameraListener.onCameraOpened();
    }

    private void setupPreview() {
        try {
            if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                this.mCamera.setPreviewDisplay(this.mPreview.getSurfaceHolder());
            } else {
                this.mCamera.setPreviewTexture(this.mPreview.getSurfaceTexture());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraParameters = null;
            this.mPreviewSize = null;
            this.mCaptureSize = null;
            this.mCameraListener.onCameraClosed();
        }
    }

    private int calculatePreviewRotation() {
        if (this.mCameraInfo.facing == 1) {
            return (this.mCameraInfo.orientation - this.mDisplayOrientation + 360 + 180) % 360;
        }
        return (this.mCameraInfo.orientation - this.mDisplayOrientation + 360) % 360;
    }

    private int calculateCaptureRotation() {
        int previewRotation = this.calculatePreviewRotation();
        if (this.mCameraInfo.facing == 1) {
            return (previewRotation + 180 + 2 * this.mDisplayOrientation + 720) % 360;
        }
        return previewRotation;
    }

    private void adjustCameraParameters() {
        boolean invertPreviewSizes = this.mDisplayOrientation % 180 != 0;
        this.mPreview.setTruePreviewSize(invertPreviewSizes ? this.getPreviewResolution().getHeight() : this.getPreviewResolution().getWidth(), invertPreviewSizes ? this.getPreviewResolution().getWidth() : this.getPreviewResolution().getHeight());
        this.mCameraParameters.setPreviewSize(this.getPreviewResolution().getWidth(), this.getPreviewResolution().getHeight());
        this.mCameraParameters.setPictureSize(this.getCaptureResolution().getWidth(), this.getCaptureResolution().getHeight());
        int rotation = this.calculateCaptureRotation();
        this.mCameraParameters.setRotation(rotation);
        this.setFocus(this.mFocus);
        this.setFlash(this.mFlash);
        this.mCamera.setParameters(this.mCameraParameters);
    }

    private TreeSet<AspectRatio> findCommonAspectRatios(List<Camera.Size> previewSizes, List<Camera.Size> captureSizes) {
        HashSet<AspectRatio> previewAspectRatios = new HashSet<AspectRatio>();
        for (Camera.Size size : previewSizes) {
            if (size.width < CameraKit.Internal.screenHeight || size.height < CameraKit.Internal.screenWidth) continue;
            previewAspectRatios.add(AspectRatio.of(size.width, size.height));
        }
        HashSet<AspectRatio> captureAspectRatios = new HashSet<AspectRatio>();
        for (Camera.Size size : captureSizes) {
            captureAspectRatios.add(AspectRatio.of(size.width, size.height));
        }
        TreeSet<AspectRatio> treeSet = new TreeSet<AspectRatio>();
        for (AspectRatio aspectRatio : previewAspectRatios) {
            if (!captureAspectRatios.contains(aspectRatio)) continue;
            treeSet.add(aspectRatio);
        }
        return treeSet;
    }

    private void initMediaRecorder() {
        this.mMediaRecorder = new MediaRecorder();
        this.mCamera.unlock();
        this.mMediaRecorder.setCamera(this.mCamera);
        this.mMediaRecorder.setVideoSource(1);
        this.mMediaRecorder.setAudioSource(0);
        this.mMediaRecorder.setProfile(this.getCamcorderProfile(this.mVideoQuality));
        this.mVideoFile = new File(this.mPreview.getView().getContext().getExternalFilesDir(null), "video.mp4");
        this.mMediaRecorder.setOutputFile(this.mVideoFile.getAbsolutePath());
        this.mMediaRecorder.setOrientationHint(this.mCameraInfo.orientation);
    }

    private void prepareMediaRecorder() {
        try {
            this.mMediaRecorder.prepare();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CamcorderProfile getCamcorderProfile(int videoQuality) {
        CamcorderProfile camcorderProfile = null;
        switch (videoQuality) {
            case 0: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)4)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)4);
                    break;
                }
                return this.getCamcorderProfile(5);
            }
            case 1: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)5)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)5);
                    break;
                }
                return this.getCamcorderProfile(0);
            }
            case 2: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)6)) {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)6);
                    break;
                }
                return this.getCamcorderProfile(1);
            }
            case 3: {
                try {
                    camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)8);
                    break;
                }
                catch (Exception e) {
                    return this.getCamcorderProfile(4);
                }
            }
            case 4: {
                camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)1);
                break;
            }
            case 5: {
                camcorderProfile = CamcorderProfile.get((int)this.mCameraId, (int)0);
            }
        }
        return camcorderProfile;
    }

    void setTapToAutofocusListener(Camera.AutoFocusCallback callback) {
        if (this.mFocus != 2) {
            throw new IllegalArgumentException("Please set the camera to FOCUS_TAP.");
        }
        this.mAutofocusCallback = callback;
    }

    private int getFocusAreaSize() {
        return 300;
    }

    private int getFocusMeteringAreaWeight() {
        return 1000;
    }

    private void detachFocusTapListener() {
        this.mPreview.getView().setOnTouchListener(null);
    }

    private void attachFocusTapListener() {
        this.mPreview.getView().setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1 && Camera1.this.mCamera != null) {
                    Camera.Parameters parameters = Camera1.this.mCamera.getParameters();
                    String focusMode = parameters.getFocusMode();
                    Rect rect = Camera1.this.calculateFocusArea(event.getX(), event.getY());
                    ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                    meteringAreas.add(new Camera.Area(rect, Camera1.this.getFocusMeteringAreaWeight()));
                    if (parameters.getMaxNumFocusAreas() != 0 && focusMode != null && (focusMode.equals("auto") || focusMode.equals("macro") || focusMode.equals("continuous-picture") || focusMode.equals("continuous-video"))) {
                        parameters.setFocusMode("auto");
                        parameters.setFocusAreas(meteringAreas);
                        if (parameters.getMaxNumMeteringAreas() > 0) {
                            parameters.setMeteringAreas(meteringAreas);
                        }
                        if (!parameters.getSupportedFocusModes().contains("auto")) {
                            return false;
                        }
                        Camera1.this.mCamera.setParameters(parameters);
                        Camera1.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean success, Camera camera) {
                                Camera1.this.resetFocus(success, camera);
                            }
                        });
                    } else if (parameters.getMaxNumMeteringAreas() > 0) {
                        if (!parameters.getSupportedFocusModes().contains("auto")) {
                            return false;
                        }
                        parameters.setFocusMode("auto");
                        parameters.setFocusAreas(meteringAreas);
                        parameters.setMeteringAreas(meteringAreas);
                        Camera1.this.mCamera.setParameters(parameters);
                        Camera1.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean success, Camera camera) {
                                Camera1.this.resetFocus(success, camera);
                            }
                        });
                    } else {
                        Camera1.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean success, Camera camera) {
                                if (Camera1.this.mAutofocusCallback != null) {
                                    Camera1.this.mAutofocusCallback.onAutoFocus(success, camera);
                                }
                            }
                        });
                    }
                }
                return true;
            }
        });
    }

    private void resetFocus(final boolean success, final Camera camera) {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (camera != null) {
                    camera.cancelAutoFocus();
                    Camera.Parameters params = camera.getParameters();
                    if (params.getFocusMode() != "continuous-picture") {
                        params.setFocusMode("continuous-picture");
                        params.setFocusAreas(null);
                        params.setMeteringAreas(null);
                        camera.setParameters(params);
                    }
                    if (Camera1.this.mAutofocusCallback != null) {
                        Camera1.this.mAutofocusCallback.onAutoFocus(success, camera);
                    }
                }
            }
        }, 3000L);
    }

    private Rect calculateFocusArea(float x, float y) {
        int centerX = this.clamp(Float.valueOf(x / (float)this.mPreview.getView().getWidth() * 2000.0f - 1000.0f).intValue(), this.getFocusAreaSize());
        int centerY = this.clamp(Float.valueOf(y / (float)this.mPreview.getView().getHeight() * 2000.0f - 1000.0f).intValue(), this.getFocusAreaSize());
        return new Rect(centerX - this.getFocusAreaSize() / 2, centerY - this.getFocusAreaSize() / 2, centerX + this.getFocusAreaSize() / 2, centerY + this.getFocusAreaSize() / 2);
    }

    private int clamp(int touchCoordinateInCameraReper, int focusAreaSize) {
        int result = Math.abs(touchCoordinateInCameraReper) + focusAreaSize / 2 > 1000 ? (touchCoordinateInCameraReper > 0 ? 1000 - focusAreaSize / 2 : -1000 + focusAreaSize / 2) : touchCoordinateInCameraReper - focusAreaSize / 2;
        return result;
    }
}

