/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.MysqldExecutable;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.distribution.Service;
import com.wix.mysql.io.NotifyingStreamProcessor;
import com.wix.mysql.utils.Utils;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqldProcess
extends AbstractProcess<MysqldConfig, MysqldExecutable, MysqldProcess> {
    private static final Logger logger = LoggerFactory.getLogger(MysqldProcess.class);
    private NotifyingStreamProcessor outputWatch;

    public MysqldProcess(Distribution distribution, MysqldConfig config, IRuntimeConfig runtimeConfig, MysqldExecutable executable) throws IOException {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, (Executable)executable);
    }

    public void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        this.outputWatch = new NotifyingStreamProcessor(StreamToLineProcessor.wrap((IStreamProcessor)runtimeConfig.getProcessOutput().getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)this.outputWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)this.outputWatch);
        NotifyingStreamProcessor.ResultMatchingListener startupListener = this.outputWatch.addListener(new NotifyingStreamProcessor.ResultMatchingListener("ready for connections"));
        try {
            startupListener.waitForResult(((MysqldConfig)this.getConfig()).getTimeout(TimeUnit.MILLISECONDS));
            if (!startupListener.isInitWithSuccess()) {
                throw new RuntimeException("mysql start failed with error: " + startupListener.getFailureFound());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected List<String> getCommandLine(Distribution distribution, MysqldConfig config, IExtractedFileSet exe) throws IOException {
        return Service.commandLine(config, exe);
    }

    protected synchronized void stopInternal() {
        logger.info("try to stop mysqld");
        if (!this.stopUsingMysqldadmin()) {
            logger.warn("could not stop mysqld via mysqladmin, try next");
            if (!this.sendKillToProcess()) {
                logger.warn("could not stop mysqld, try next");
                if (!this.sendTermToProcess()) {
                    logger.warn("could not stop mysqld, try next");
                    if (!this.tryKillToProcess()) {
                        logger.warn("could not stop mysqld the second time, try one last thing");
                        try {
                            this.stopProcess();
                        }
                        catch (IllegalStateException e) {
                            logger.error("error while trying to stop mysql process", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    protected void cleanupInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopUsingMysqldadmin() {
        InputStreamReader stdErr;
        boolean retValue;
        block9: {
            NotifyingStreamProcessor.ResultMatchingListener shutdownListener = this.outputWatch.addListener(new NotifyingStreamProcessor.ResultMatchingListener(": Shutdown complete"));
            retValue = false;
            stdErr = null;
            try {
                String cmd = Paths.get(this.getExecutable().getFile().baseDir().getAbsolutePath(), "bin", "mysqladmin").toString();
                Process p = Runtime.getRuntime().exec(new String[]{cmd, "--no-defaults", "--protocol=tcp", String.format("-u%s", "root"), String.format("--port=%s", ((MysqldConfig)this.getConfig()).getPort()), "shutdown"});
                retValue = p.waitFor() == 0;
                stdErr = new InputStreamReader(p.getErrorStream());
                if (retValue) {
                    shutdownListener.waitForResult(((MysqldConfig)this.getConfig()).getTimeout(TimeUnit.MILLISECONDS));
                    if (Platform.detect() == Platform.Windows) {
                        Thread.sleep(2000L);
                    }
                    if (!shutdownListener.isInitWithSuccess()) {
                        logger.error("mysql shutdown failed. Expected to find in output: 'Shutdown complete', got: " + shutdownListener.getFailureFound());
                        retValue = false;
                    } else {
                        logger.debug("mysql shutdown succeeded.");
                        retValue = true;
                    }
                    break block9;
                }
                String errOutput = Utils.readToString(stdErr);
                if (errOutput.contains("Can't connect to MySQL server on")) {
                    logger.warn("mysql was already shutdown - no need to add extra shutdown hook - process does it out of the box.");
                    retValue = true;
                    break block9;
                }
                logger.error("mysql shutdown failed with error code: " + p.waitFor() + " and message: " + errOutput);
            }
            catch (IOException | InterruptedException e) {
                try {
                    logger.warn("Encountered error why shutting down process.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Utils.closeCloseables(stdErr);
                    throw throwable;
                }
                Utils.closeCloseables(stdErr);
            }
        }
        Utils.closeCloseables(stdErr);
        return retValue;
    }

    private MysqldExecutable getExecutable() {
        try {
            Field f = AbstractProcess.class.getDeclaredField("executable");
            f.setAccessible(true);
            return (MysqldExecutable)((Object)f.get((Object)this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

