/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.windowsazure.messaging.Installation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class InstallationTemplate {
    private String body;
    private Map<String, String> headers;
    private String expiry;
    private List<String> tags;

    public InstallationTemplate() {
        this(null);
    }

    public InstallationTemplate(String body) {
        this(body, null);
    }

    public InstallationTemplate(String body, List<String> tags) {
        this.body = body;
        if (tags != null) {
            for (String tag : tags) {
                this.addTag(tag);
            }
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String headerName, String headerValue) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(headerName, headerValue);
    }

    public void removeHeader(String headerName) {
        if (this.headers == null) {
            return;
        }
        this.headers.remove(headerName);
    }

    public void clearHeaders() {
        if (this.headers == null) {
            return;
        }
        this.headers.clear();
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void clearTags() {
        if (this.tags == null) {
            return;
        }
        this.tags.clear();
    }

    public static InstallationTemplate fromJson(String json) {
        return (InstallationTemplate)new Gson().fromJson(json, InstallationTemplate.class);
    }

    public static Installation fromJson(InputStream json) throws IOException {
        return Installation.fromJson(IOUtils.toString((InputStream)json));
    }

    public String toJson() {
        return new GsonBuilder().disableHtmlEscaping().create().toJson((Object)this);
    }
}

