/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util;

import com.pax.market.api.sdk.java.base.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class);

    private ZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(String filePath) {
        File target = null;
        File source = new File(filePath);
        if (source.exists()) {
            String zipName = source.getName() + ".zip";
            target = new File(source.getParent(), zipName);
            if (target.exists()) {
                target.delete();
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(target);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipUtil.addEntry("/", source, zos);
            }
            catch (IOException e) {
                File file;
                try {
                    logger.error(String.format("error zip file '%s'", filePath), (Throwable)e);
                    file = null;
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(zos, fos);
                    throw throwable;
                }
                IOUtil.closeQuietly(zos, fos);
                return file;
            }
            IOUtil.closeQuietly(zos, fos);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addEntry(String base, File source, ZipOutputStream zos) throws IOException {
        String entry = base + source.getName();
        if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.addEntry(entry + "/", file, zos);
                ++n2;
            }
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[10240];
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis, buffer.length);
            int read = 0;
            zos.putNextEntry(new ZipEntry(entry));
            while ((read = bis.read(buffer, 0, buffer.length)) != -1) {
                zos.write(buffer, 0, read);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(bis, fis);
            throw throwable;
        }
        IOUtil.closeQuietly(bis, fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzip(String filePath) {
        File source = new File(filePath);
        if (source.exists()) {
            ZipInputStream zis = null;
            FileInputStream fis = null;
            try {
                ZipEntry entry;
                fis = new FileInputStream(source);
                zis = new ZipInputStream(fis);
                while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
                    ZipUtil.writeEachFile(source, zis, entry);
                }
                zis.closeEntry();
            }
            catch (IOException e) {
                boolean bl;
                try {
                    logger.error(String.format("error write single file %s", filePath), (Throwable)e);
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(zis, fis);
                    throw throwable;
                }
                IOUtil.closeQuietly(zis, fis);
                return bl;
            }
            IOUtil.closeQuietly(zis, fis);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEachFile(File source, ZipInputStream zis, ZipEntry entry) {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            File target = new File(source.getParent(), entry.getName());
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(target);
            bos = new BufferedOutputStream(fos);
            int read = 0;
            byte[] buffer = new byte[10240];
            while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, read);
            }
            bos.flush();
        }
        catch (IOException e) {
            try {
                logger.error("error writeEachFile", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fos, bos);
                throw throwable;
            }
            IOUtil.closeQuietly(fos, bos);
        }
        IOUtil.closeQuietly(fos, bos);
    }
}

