/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util;

import com.google.gson.JsonParseException;
import com.pax.market.api.sdk.java.base.client.ThreadLocalProxyAuthenticator;
import com.pax.market.api.sdk.java.base.constant.ResultCode;
import com.pax.market.api.sdk.java.base.dto.SdkObject;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.FileUtils;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import com.pax.market.api.sdk.java.base.util.StringUtils;
import com.pax.market.api.sdk.java.base.util.auth.OkHttpAuthenticator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static Locale locale = Locale.ENGLISH;
    public static final String IOEXCTION_FLAG = "IOException-";
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static void setLocal(Locale locale) {
        HttpUtils.locale = locale;
    }

    private HttpUtils() {
    }

    public static String pingHosts(String dynamicHost, String staticHost, Proxy proxy, String basicAuthorization, PasswordAuthentication passwordAuthentication) {
        return HttpUtils.pingHostItem(dynamicHost, proxy, basicAuthorization, passwordAuthentication) != null ? dynamicHost : HttpUtils.pingHostItem(staticHost, proxy, basicAuthorization, passwordAuthentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String pingHostItem(String host, Proxy proxy, String basicAuthorization, PasswordAuthentication passwordAuthentication) {
        logger.error("Ping host start:");
        HttpLoggingInterceptor mLoggingInterceptor = new HttpLoggingInterceptor();
        mLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        OkHttpClient.Builder httpClientBuilder = OK_HTTP_CLIENT.newBuilder().addInterceptor((Interceptor)mLoggingInterceptor).retryOnConnectionFailure(false).connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS);
        boolean clearCredentials = false;
        if (proxy != null) {
            httpClientBuilder.proxy(proxy);
            if (proxy.type() == Proxy.Type.HTTP && basicAuthorization != null) {
                httpClientBuilder.proxyAuthenticator((okhttp3.Authenticator)new OkHttpAuthenticator(basicAuthorization));
            } else if (proxy.type() == Proxy.Type.SOCKS && passwordAuthentication != null) {
                clearCredentials = true;
                Authenticator.setDefault(ThreadLocalProxyAuthenticator.getInstance());
                ThreadLocalProxyAuthenticator.getInstance().setCredentials(passwordAuthentication);
            } else {
                httpClientBuilder.proxyAuthenticator(okhttp3.Authenticator.NONE);
            }
        }
        try {
            String pingHost = host;
            if (host.endsWith("p-market-api/v1")) {
                pingHost = host.substring(0, host.indexOf("p-market-api/v1"));
            }
            Response execute = httpClientBuilder.build().newCall(new Request.Builder().url(pingHost + "healthcheck/ping").build()).execute();
            logger.error("Ping host end:");
            String string = host;
            return string;
        }
        catch (IOException e) {
            logger.error("Ping failed: {}", (Object)e.toString());
        }
        finally {
            if (clearCredentials) {
                ThreadLocalProxyAuthenticator.clearCredentials();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String request(String requestUrl, SdkRequest.RequestMethod requestMethod, int connectTimeout, int readTimeout, int writeTimeout, String userData, Map<String, String> headerMap, String saveFilePath, Proxy proxy, String basicAuthorization, PasswordAuthentication passwordAuthentication) {
        FileOutputStream fileOutputStream = null;
        String filePath = null;
        boolean clearCredentials = false;
        try {
            Response response;
            HttpLoggingInterceptor mLoggingInterceptor = new HttpLoggingInterceptor();
            mLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
            String httpClientBuilder = OK_HTTP_CLIENT.newBuilder().addInterceptor((Interceptor)mLoggingInterceptor).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
            if (proxy != null) {
                httpClientBuilder.proxy(proxy);
                if (proxy.type() == Proxy.Type.HTTP && basicAuthorization != null) {
                    httpClientBuilder.proxyAuthenticator((okhttp3.Authenticator)new OkHttpAuthenticator(basicAuthorization));
                } else if (proxy.type() == Proxy.Type.SOCKS && passwordAuthentication != null) {
                    clearCredentials = true;
                    Authenticator.setDefault(ThreadLocalProxyAuthenticator.getInstance());
                    ThreadLocalProxyAuthenticator.getInstance().setCredentials(passwordAuthentication);
                } else {
                    httpClientBuilder.proxyAuthenticator(okhttp3.Authenticator.NONE);
                }
            }
            Request.Builder requestBuilder = new Request.Builder().url(requestUrl);
            switch (requestMethod) {
                case POST: {
                    requestBuilder.post(RequestBody.create((MediaType)JSON, (String)userData));
                    break;
                }
                case PUT: {
                    requestBuilder.put(RequestBody.create((MediaType)JSON, (String)userData));
                    break;
                }
                case DELETE: {
                    requestBuilder.delete();
                    break;
                }
                default: {
                    requestBuilder.get();
                }
            }
            if (locale != null) {
                requestBuilder.addHeader("Accept-Language", HttpUtils.getLanguageTag(locale));
            }
            if (headerMap != null) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    requestBuilder.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = httpClientBuilder.build().newCall(requestBuilder.build()).execute()).isSuccessful() && saveFilePath != null) {
                int bytesRead;
                filePath = saveFilePath + File.separator + FileUtils.generateMixString(16);
                File fileDir = new File(saveFilePath);
                if (!fileDir.exists()) {
                    fileDir.mkdirs();
                }
                fileOutputStream = new FileOutputStream(filePath);
                byte[] buffer = new byte[4096];
                while ((bytesRead = response.body().byteStream().read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
                String string = JsonUtils.getSdkJsonStr(ResultCode.SUCCESS.getCode(), filePath);
                return string;
            }
            String responseBody = response.body().string();
            try {
                SdkObject sdkObject = JsonUtils.fromJson(responseBody, SdkObject.class);
                if (sdkObject == null) {
                    String buffer = JsonUtils.getSdkJsonStr(response.code(), responseBody);
                    return buffer;
                }
            }
            catch (IllegalStateException e) {
                logger.error("IllegalStateException Occurred. Details: {}", (Object)e.toString());
                String buffer = JsonUtils.getSdkJsonStr(response.code(), responseBody);
                return buffer;
            }
            catch (JsonParseException e1) {
                String buffer;
                block59: {
                    logger.error("JsonParseException Occurred. Details: {}", (Object)e1.toString());
                    buffer = JsonUtils.getSdkJsonStr(response.code(), responseBody);
                    if (fileOutputStream == null) break block59;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("IOException Occurred. Details: {}", (Object)e.toString());
                    }
                }
                if (clearCredentials) {
                    ThreadLocalProxyAuthenticator.clearCredentials();
                }
                return buffer;
            }
            String string = responseBody;
            return string;
            {
                catch (SocketTimeoutException localSocketTimeoutException) {
                    FileUtils.deleteFile(filePath);
                    logger.error("SocketTimeoutException Occurred. Details: {}", (Object)localSocketTimeoutException.toString());
                    httpClientBuilder = JsonUtils.getSdkJson(ResultCode.SDK_CONNECT_TIMEOUT.getCode(), IOEXCTION_FLAG + localSocketTimeoutException.toString());
                    return httpClientBuilder;
                }
                catch (ConnectException localConnectException) {
                    FileUtils.deleteFile(filePath);
                    logger.error("ConnectException Occurred. Details: {}", (Object)localConnectException.toString());
                    httpClientBuilder = JsonUtils.getSdkJson(ResultCode.SDK_UN_CONNECT.getCode(), IOEXCTION_FLAG + localConnectException.toString());
                    return httpClientBuilder;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FileUtils.deleteFile(filePath);
                    logger.error("FileNotFoundException Occurred. Details: {}", (Object)fileNotFoundException.toString());
                    httpClientBuilder = JsonUtils.getSdkJson(ResultCode.SDK_FILE_NOT_FOUND.getCode(), fileNotFoundException.toString());
                    return httpClientBuilder;
                }
                catch (Exception ignored) {
                    FileUtils.deleteFile(filePath);
                    logger.error("Exception Occurred. Details: {}", (Object)ignored.toString());
                    String errMsg = ignored.toString();
                    if (ignored instanceof IOException) {
                        errMsg = IOEXCTION_FLAG + ignored.toString();
                    }
                    String string2 = JsonUtils.getSdkJsonStr(ResultCode.SDK_RQUEST_EXCEPTION.getCode(), errMsg);
                    return string2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error("IOException Occurred. Details: {}", (Object)e.toString());
                }
            }
            if (clearCredentials) {
                ThreadLocalProxyAuthenticator.clearCredentials();
            }
        }
    }

    public static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (StringUtils.isEmpty(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return HttpUtils.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return HttpUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return HttpUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return HttpUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                logger.error("IOException Occurred. Details: {}", (Object)e.toString());
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                logger.error("IOException Occurred. Details: {}", (Object)e.toString());
            }
        }
        return result;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    public static byte[] compressData(byte[] bytes) throws IOException {
        if (null == bytes) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(bytes);
        gzipOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static String getLanguageTag(Locale locale) {
        if (locale != null) {
            String localeStr = locale.toString();
            return localeStr.replace("_", "-");
        }
        return null;
    }
}

