/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.client;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ThreadLocalProxyAuthenticator
extends Authenticator {
    private static final ThreadLocal<PasswordAuthentication> credentials = new ThreadLocal();

    public static final ThreadLocalProxyAuthenticator getInstance() {
        return SingletonHolder.instance;
    }

    public void setCredentials(PasswordAuthentication passwordAuthentication) {
        credentials.set(passwordAuthentication);
    }

    public static void clearCredentials() {
        ThreadLocalProxyAuthenticator authenticator = ThreadLocalProxyAuthenticator.getInstance();
        credentials.set(null);
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        return credentials.get();
    }

    private static class SingletonHolder {
        private static final ThreadLocalProxyAuthenticator instance = new ThreadLocalProxyAuthenticator();

        private SingletonHolder() {
        }
    }
}

