/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.serialize;

import com.google.protobuf.MessageLite;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

@SpiMeta(name="grpc-pb")
public class GrpcPbSerialization
implements Serialization {
    public byte[] serialize(Object obj) throws IOException {
        if (obj == null) {
            throw new IllegalArgumentException("can't serialize null.");
        }
        if (MessageLite.class.isAssignableFrom(obj.getClass())) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(((MessageLite)obj).toByteArray());
            baos.flush();
            return baos.toByteArray();
        }
        throw new IllegalArgumentException("can't serialize " + obj.getClass());
    }

    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws IOException {
        if (MessageLite.class.isAssignableFrom(clazz)) {
            try {
                ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                Method method = clazz.getDeclaredMethod("parseFrom", InputStream.class);
                return (T)method.invoke(null, input);
            }
            catch (Exception e) {
                throw new MotanFrameworkException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("can't serialize " + clazz);
    }

    public byte[] serializeMulti(Object[] data) throws IOException {
        if (data.length == 1) {
            return this.serialize(data[0]);
        }
        throw new MotanServiceException("GrpcPbSerialization not support serialize multi Object");
    }

    public Object[] deserializeMulti(byte[] data, Class<?>[] classes) throws IOException {
        if (classes.length != 1) {
            throw new MotanServiceException("only single value serialize was supported in GrpcPbSerialization");
        }
        Object[] objects = new Object[]{this.deserialize(data, classes[0])};
        return objects;
    }

    public int getSerializationNumber() {
        return 1;
    }
}

