/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.serialize;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

@SpiMeta(name="protobuf")
public class ProtobufSerialization
implements Serialization {
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream output = CodedOutputStream.newInstance((OutputStream)baos);
        output.writeBoolNoTag(obj == null);
        if (obj == null) {
            output.flush();
            return baos.toByteArray();
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            output.writeSInt32NoTag(((Integer)obj).intValue());
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            output.writeSInt64NoTag(((Long)obj).longValue());
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            output.writeBoolNoTag(((Boolean)obj).booleanValue());
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            output.writeRawByte(((Byte)obj).byteValue());
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            output.writeSInt32NoTag((int)((Character)obj).charValue());
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            output.writeSInt32NoTag((int)((Short)obj).shortValue());
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            output.writeDoubleNoTag(((Double)obj).doubleValue());
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            output.writeFloatNoTag(((Float)obj).floatValue());
        } else if (clazz == String.class) {
            output.writeStringNoTag(obj.toString());
        } else if (MessageLite.class.isAssignableFrom(clazz)) {
            output.writeMessageNoTag((MessageLite)obj);
        } else if (Throwable.class.isAssignableFrom(clazz)) {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
        } else {
            throw new IllegalArgumentException("can't serialize " + clazz);
        }
        output.flush();
        return baos.toByteArray();
    }

    public <T> T deserialize(byte[] bytes, Class<T> clazz) throws IOException {
        if (bytes[0] == 1) {
            return null;
        }
        Object value = null;
        CodedInputStream in = CodedInputStream.newInstance((byte[])bytes, (int)1, (int)(bytes.length - 1));
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            value = in.readSInt32();
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            value = in.readSInt64();
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            value = in.readBool();
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            value = in.readRawByte();
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            value = Character.valueOf((char)in.readSInt32());
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            value = (short)in.readSInt32();
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            value = in.readDouble();
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            value = Float.valueOf(in.readFloat());
        } else if (clazz == String.class) {
            value = in.readString();
        } else if (MessageLite.class.isAssignableFrom(clazz)) {
            try {
                Method method = clazz.getDeclaredMethod("newBuilder", new Class[0]);
                MessageLite.Builder builder = (MessageLite.Builder)method.invoke(null, new Object[0]);
                in.readMessage(builder, null);
                value = builder.build();
            }
            catch (Exception e) {
                throw new MotanFrameworkException((Throwable)e);
            }
        } else if (Throwable.class.isAssignableFrom(clazz)) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes, 0, bytes.length - 1));
                value = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new MotanFrameworkException((Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("can't deserialize " + clazz);
        }
        return (T)value;
    }
}

