/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4.yar;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.yar.AttachmentRequest;
import com.weibo.api.motan.protocol.yar.YarMessageRouter;
import com.weibo.api.motan.protocol.yar.YarProtocolUtil;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.netty4.http.HttpMessageHandler;
import com.weibo.api.motan.transport.netty4.http.NettyHttpUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.yar.YarProtocol;
import com.weibo.yar.YarResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YarMessageHandlerWrapper
implements HttpMessageHandler {
    public static final String BAD_REQUEST = "/bad-request";
    public static final String ROOT_PATH = "/";
    public static final String STATUS_PATH = "/rpcstatus";
    protected String switcherName = "feature.configserver.heartbeat";
    private final YarMessageRouter orgHandler;

    public YarMessageHandlerWrapper(MessageHandler orgHandler) {
        if (orgHandler == null) {
            throw new MotanFrameworkException("messageHandler is null!");
        }
        if (!(orgHandler instanceof YarMessageRouter)) {
            throw new MotanFrameworkException("YarMessageHandlerWrapper can not wrapper " + orgHandler.getClass().getSimpleName());
        }
        this.orgHandler = (YarMessageRouter)orgHandler;
    }

    public FullHttpResponse handle(Channel channel, FullHttpRequest httpRequest) {
        byte[] responseBytes;
        YarResponse yarResponse;
        QueryStringDecoder decoder = new QueryStringDecoder(httpRequest.uri());
        String path = decoder.path();
        if (BAD_REQUEST.equals(path)) {
            return NettyHttpUtil.buildDefaultResponse((String)"bad request!", (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST);
        }
        if (ROOT_PATH.equals(path) || STATUS_PATH.equals(path)) {
            if (this.isSwitchOpen()) {
                return NettyHttpUtil.buildDefaultResponse((String)"ok!", (HttpResponseStatus)HttpResponseStatus.OK);
            }
            return NettyHttpUtil.buildErrorResponse((String)"service not available!");
        }
        HashMap<String, String> attachments = null;
        if (!decoder.parameters().isEmpty()) {
            attachments = new HashMap<String, String>(decoder.parameters().size());
            for (Map.Entry entry : decoder.parameters().entrySet()) {
                attachments.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
        }
        String packagerName = "JSON";
        try {
            ByteBuf buf = httpRequest.content();
            byte[] contentBytes = new byte[buf.readableBytes()];
            buf.getBytes(0, contentBytes);
            AttachmentRequest yarRequest = new AttachmentRequest(YarProtocol.buildRequest((byte[])contentBytes), attachments);
            yarRequest.setRequestPath(path);
            yarResponse = (YarResponse)this.orgHandler.handle(channel, (Object)yarRequest);
        }
        catch (Exception e) {
            LoggerUtil.error((String)"YarMessageHandlerWrapper handle yar request fail.", (Throwable)e);
            yarResponse = YarProtocolUtil.buildDefaultErrorResponse(e.getMessage(), packagerName);
        }
        try {
            responseBytes = YarProtocol.toProtocolBytes((YarResponse)yarResponse);
        }
        catch (IOException e) {
            throw new MotanFrameworkException("convert yar response to bytes fail.", (Throwable)e);
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])responseBytes));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-www-form-urlencoded");
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpResponse.content().readableBytes());
        if (HttpUtil.isKeepAlive((HttpMessage)httpRequest)) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        return httpResponse;
    }

    private boolean isSwitchOpen() {
        return MotanSwitcherUtil.isOpen((String)this.switcherName);
    }
}

