/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.yar;

import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.yar.AttachmentRequest;
import com.weibo.api.motan.protocol.yar.annotation.YarConfig;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ReflectUtil;
import com.weibo.yar.YarRequest;
import com.weibo.yar.YarResponse;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class YarProtocolUtil {
    public static String getYarPath(Class<?> interfaceClazz, URL url) {
        YarConfig config;
        if (interfaceClazz != null && (config = interfaceClazz.getAnnotation(YarConfig.class)) != null && StringUtils.isNotBlank((CharSequence)config.path())) {
            return config.path();
        }
        return "/" + url.getGroup() + "/" + url.getPath();
    }

    public static Request convert(YarRequest yarRequest, Class<?> interfaceClass) {
        DefaultRequest request = new DefaultRequest();
        request.setInterfaceName(interfaceClass.getName());
        request.setMethodName(yarRequest.getMethodName());
        request.setRequestId(yarRequest.getId());
        YarProtocolUtil.addArguments(request, interfaceClass, yarRequest.getMethodName(), yarRequest.getParameters());
        if (yarRequest instanceof AttachmentRequest) {
            request.setAttachments(((AttachmentRequest)yarRequest).getAttachments());
        }
        return request;
    }

    public static YarRequest convert(Request request, String packagerName) {
        YarRequest yarRequest = new YarRequest();
        yarRequest.setId(request.getRequestId());
        yarRequest.setMethodName(request.getMethodName());
        yarRequest.setPackagerName(packagerName);
        yarRequest.setParameters(request.getArguments());
        return yarRequest;
    }

    public static Response convert(YarResponse yarResponse) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(yarResponse.getId());
        response.setValue(yarResponse.getRet());
        if (StringUtils.isNotBlank((CharSequence)yarResponse.getError())) {
            response.setException((Exception)new MotanBizException(yarResponse.getError()));
        }
        return response;
    }

    public static YarResponse convert(Response response, String packagerName) {
        YarResponse yarResponse = new YarResponse();
        yarResponse.setId(response.getRequestId());
        yarResponse.setPackagerName(packagerName);
        if (response.getException() != null) {
            if (response.getException() instanceof MotanBizException) {
                yarResponse.setError(response.getException().getCause().getMessage());
            } else {
                yarResponse.setError(response.getException().getMessage());
            }
        } else {
            yarResponse.setRet(response.getValue());
        }
        return yarResponse;
    }

    private static void addArguments(DefaultRequest request, Class<?> interfaceClass, String methodName, Object[] arguments) {
        Method[] methods;
        Method targetMethod = null;
        for (Method m : methods = interfaceClass.getDeclaredMethods()) {
            if (!m.getName().equalsIgnoreCase(methodName) || m.getParameterTypes().length != arguments.length) continue;
            targetMethod = m;
            break;
        }
        if (targetMethod == null) {
            throw new MotanServiceException("cann't find request method. method name " + methodName);
        }
        request.setParamtersDesc(ReflectUtil.getMethodParamDesc(targetMethod));
        if (arguments != null && arguments.length > 0) {
            Class<?>[] argumentClazz = targetMethod.getParameterTypes();
            request.setArguments(YarProtocolUtil.adaptParams(targetMethod, arguments, argumentClazz));
        }
    }

    public static YarResponse buildDefaultErrorResponse(String errMsg, String packagerName) {
        YarResponse yarResponse = new YarResponse();
        yarResponse.setPackagerName(packagerName);
        yarResponse.setError(errMsg);
        yarResponse.setStatus("500");
        return yarResponse;
    }

    private static Object[] adaptParams(Method method, Object[] arguments, Class<?>[] argumentClazz) {
        for (int i = 0; i < argumentClazz.length; ++i) {
            try {
                if ("int".equals(argumentClazz[i].getName()) || "java.lang.Integer".equals(argumentClazz[i].getName())) {
                    if (arguments[i] == null) {
                        arguments[i] = 0;
                        continue;
                    }
                    if (arguments[i] instanceof String) {
                        arguments[i] = Integer.parseInt((String)arguments[i]);
                        continue;
                    }
                    if (arguments[i] instanceof Number) {
                        arguments[i] = ((Number)arguments[i]).intValue();
                        continue;
                    }
                    throw new RuntimeException();
                }
                if ("long".equals(argumentClazz[i].getName()) || "java.lang.Long".equals(argumentClazz[i].getName())) {
                    if (arguments[i] == null) {
                        arguments[i] = 0;
                        continue;
                    }
                    if (arguments[i] instanceof String) {
                        arguments[i] = Long.parseLong((String)arguments[i]);
                        continue;
                    }
                    if (arguments[i] instanceof Number) {
                        arguments[i] = ((Number)arguments[i]).longValue();
                        continue;
                    }
                    throw new RuntimeException();
                }
                if ("float".equals(argumentClazz[i].getName()) || "java.lang.Float".equals(argumentClazz[i].getName())) {
                    if (arguments[i] == null) {
                        arguments[i] = Float.valueOf(0.0f);
                        continue;
                    }
                    if (arguments[i] instanceof String) {
                        arguments[i] = Float.valueOf(Float.parseFloat((String)arguments[i]));
                        continue;
                    }
                    if (arguments[i] instanceof Number) {
                        arguments[i] = Float.valueOf(((Number)arguments[i]).floatValue());
                        continue;
                    }
                    throw new RuntimeException();
                }
                if ("double".equals(argumentClazz[i].getName()) || "java.lang.Double".equals(argumentClazz[i].getName())) {
                    if (arguments[i] == null) {
                        arguments[i] = Float.valueOf(0.0f);
                        continue;
                    }
                    if (arguments[i] instanceof String) {
                        arguments[i] = Double.parseDouble((String)arguments[i]);
                        continue;
                    }
                    if (arguments[i] instanceof Number) {
                        arguments[i] = ((Number)arguments[i]).doubleValue();
                        continue;
                    }
                    throw new RuntimeException();
                }
                if (!"boolean".equals(argumentClazz[i].getName()) && !"java.lang.Boolean".equals(argumentClazz[i].getName()) || arguments[i] instanceof Boolean) continue;
                if (arguments[i] instanceof String) {
                    arguments[i] = Boolean.valueOf((String)arguments[i]);
                    continue;
                }
                throw new RuntimeException();
            }
            catch (Exception e) {
                throw new MotanServiceException("adapt param fail! method:" + method.toString() + ", require param:" + argumentClazz[i].getName() + ", actual param:" + (arguments[i] == null ? null : arguments[i].getClass().getName() + "-" + arguments[i]));
            }
        }
        return arguments;
    }
}

