/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4.http;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractServer;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty4.http.NettyHttpRequestHandler;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StatisticCallback;
import com.weibo.api.motan.util.StatsUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Netty4HttpServer
extends AbstractServer
implements StatisticCallback {
    private MessageHandler messageHandler;
    private URL url;
    private io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public Netty4HttpServer(URL url, MessageHandler messageHandler) {
        this.url = url;
        this.messageHandler = messageHandler;
    }

    public boolean open() {
        if (this.isAvailable()) {
            return true;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.bossGroup == null) {
            this.bossGroup = new NioEventLoopGroup();
            this.workerGroup = new NioEventLoopGroup();
        }
        boolean shareChannel = this.url.getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
        int maxServerConnection = this.url.getIntParameter(URLParamType.maxServerConnection.getName(), URLParamType.maxServerConnection.getIntValue());
        int workerQueueSize = this.url.getIntParameter(URLParamType.workerQueueSize.getName(), 500);
        int minWorkerThread = 0;
        int maxWorkerThread = 0;
        if (shareChannel) {
            minWorkerThread = this.url.getIntParameter(URLParamType.minWorkerThread.getName(), 40);
            maxWorkerThread = this.url.getIntParameter(URLParamType.maxWorkerThread.getName(), 800);
        } else {
            minWorkerThread = this.url.getIntParameter(URLParamType.minWorkerThread.getName(), 20);
            maxWorkerThread = this.url.getIntParameter(URLParamType.maxWorkerThread.getName(), 200);
        }
        final int maxContentLength = this.url.getIntParameter(URLParamType.maxContentLength.getName(), URLParamType.maxContentLength.getIntValue());
        final NettyHttpRequestHandler handler = new NettyHttpRequestHandler((Channel)this, this.messageHandler, new ThreadPoolExecutor(minWorkerThread, maxWorkerThread, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(workerQueueSize)));
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
                ch.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength));
                ch.pipeline().addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder());
                ch.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                ch.pipeline().addLast("serverHandler", (ChannelHandler)handler);
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
        try {
            ChannelFuture f = b.bind(this.url.getPort().intValue()).sync();
            this.channel = f.channel();
        }
        catch (InterruptedException e) {
            LoggerUtil.error((String)"init http server fail.", (Throwable)e);
            return false;
        }
        this.state = ChannelState.ALIVE;
        StatsUtil.registryStatisticCallback((StatisticCallback)this);
        LoggerUtil.info((String)("Netty4HttpServer ServerChannel finish Open: url=" + this.url));
        return true;
    }

    public void close() {
        this.close(0);
    }

    public boolean isAvailable() {
        return this.state.isAliveState();
    }

    public boolean isBound() {
        return this.channel != null && this.channel.isActive();
    }

    public Response request(Request request) throws TransportException {
        throw new MotanFrameworkException("Netty4HttpServer request(Request request) method unsupport: url: " + this.url);
    }

    public void close(int timeout) {
        if (this.state.isCloseState()) {
            LoggerUtil.info((String)"NettyServer close fail: already close, url={}", (Object[])new Object[]{this.url.getUri()});
            return;
        }
        if (this.state.isUnInitState()) {
            LoggerUtil.info((String)"NettyServer close Fail: don't need to close because node is unInit state: url={}", (Object[])new Object[]{this.url.getUri()});
            return;
        }
        if (this.channel != null) {
            this.channel.close();
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            this.workerGroup = null;
            this.bossGroup = null;
        }
        this.state = ChannelState.CLOSE;
        StatsUtil.unRegistryStatisticCallback((StatisticCallback)this);
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public String statisticCallback() {
        return null;
    }

    public URL getUrl() {
        return this.url;
    }
}

