/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.NetUtils;
import com.weibo.api.motan.util.ReflectUtil;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Set;

public class MotanServerCallHandler<Req, Resp>
implements ServerCallHandler<Req, Resp> {
    private boolean inited = false;
    private Provider<?> provider;
    private String methodName;
    private String paramsDesc;
    private boolean requestStream = false;
    private boolean responseStream = false;
    private static Metadata.Key<String> REQUEST_ID = Metadata.Key.of((String)"rid", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public void init(Provider<?> provider, Method method) {
        this.checkMethod(method);
        this.provider = provider;
        this.methodName = method.getName();
        this.paramsDesc = ReflectUtil.getMethodParamDesc((Method)method);
        this.inited = true;
    }

    private void checkMethod(Method method) {
        Class<?>[] paramsClazz = method.getParameterTypes();
        if (StreamObserver.class == method.getReturnType()) {
            if (paramsClazz.length != 1 || paramsClazz[0] != StreamObserver.class) {
                throw new MotanFrameworkException("invalid grpc method:" + method.getName());
            }
            this.requestStream = true;
        } else if (paramsClazz.length == 2 && paramsClazz[1] == StreamObserver.class) {
            this.responseStream = true;
        }
    }

    public ServerCall.Listener startCall(ServerCall call, Metadata headers) {
        if (!this.inited) {
            throw new MotanFrameworkException("grpc ServerCallHandler not inited!");
        }
        if (this.provider.getUrl().getBooleanParameter(URLParamType.usegz.getName(), URLParamType.usegz.getBooleanValue()).booleanValue()) {
            call.setCompression("gzip");
        }
        return this.requestStream ? this.streamCall(call, headers) : this.unaryCall(call, headers);
    }

    private <ReqT, RespT> ServerCall.Listener<ReqT> unaryCall(final ServerCall<ReqT, RespT> call, final Metadata headers) {
        final ServerCallStreamObserverImpl<ReqT, RespT> responseObserver = new ServerCallStreamObserverImpl<ReqT, RespT>(call);
        call.request(2);
        return new ServerCall.Listener<ReqT>(){
            ReqT request;

            public void onMessage(ReqT request) {
                this.request = request;
            }

            public void onHalfClose() {
                if (this.request != null) {
                    DefaultRequest motanRequest = MotanServerCallHandler.this.getBaseMotanRequest(headers);
                    String ip = NetUtils.getHostName((SocketAddress)((SocketAddress)call.attributes().get(ServerCall.REMOTE_ADDR_KEY)));
                    if (ip != null) {
                        motanRequest.setAttachment(URLParamType.host.getName(), ip);
                    }
                    if (MotanServerCallHandler.this.responseStream) {
                        motanRequest.setArguments(new Object[]{this.request, responseObserver});
                    } else {
                        motanRequest.setArguments(new Object[]{this.request});
                    }
                    Response response = null;
                    try {
                        response = MotanServerCallHandler.this.provider.call((Request)motanRequest);
                        if (response.getValue() != null) {
                            responseObserver.onNext(response.getValue());
                            responseObserver.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        responseObserver.onError(e);
                        return;
                    }
                    responseObserver.freeze();
                    if (call.isReady()) {
                        this.onReady();
                    }
                } else {
                    call.close(Status.INTERNAL.withDescription("Half-closed without a request"), new Metadata());
                }
            }

            public void onCancel() {
                responseObserver.cancelled = true;
                if (responseObserver.onCancelHandler != null) {
                    responseObserver.onCancelHandler.run();
                }
            }

            public void onReady() {
                if (responseObserver.onReadyHandler != null) {
                    responseObserver.onReadyHandler.run();
                }
            }
        };
    }

    private <ReqT, RespT> ServerCall.Listener<ReqT> streamCall(final ServerCall<ReqT, RespT> call, Metadata headers) {
        final ServerCallStreamObserverImpl<ReqT, RespT> responseObserver = new ServerCallStreamObserverImpl<ReqT, RespT>(call);
        DefaultRequest request = this.getBaseMotanRequest(headers);
        request.setArguments(new Object[]{responseObserver});
        Response response = this.provider.call((Request)request);
        final StreamObserver requestObserver = (StreamObserver)response.getValue();
        ((ServerCallStreamObserverImpl)responseObserver).freeze();
        if (((ServerCallStreamObserverImpl)responseObserver).autoFlowControlEnabled) {
            call.request(1);
        }
        return new ServerCall.Listener<ReqT>(){
            boolean halfClosed = false;

            public void onMessage(ReqT request) {
                requestObserver.onNext(request);
                if (responseObserver.autoFlowControlEnabled) {
                    call.request(1);
                }
            }

            public void onHalfClose() {
                this.halfClosed = true;
                requestObserver.onCompleted();
            }

            public void onCancel() {
                responseObserver.cancelled = true;
                if (responseObserver.onCancelHandler != null) {
                    responseObserver.onCancelHandler.run();
                }
                if (!this.halfClosed) {
                    requestObserver.onError((Throwable)Status.CANCELLED.asException());
                }
            }

            public void onReady() {
                if (responseObserver.onReadyHandler != null) {
                    responseObserver.onReadyHandler.run();
                }
            }
        };
    }

    private DefaultRequest getBaseMotanRequest(Metadata headers) {
        DefaultRequest request = new DefaultRequest();
        request.setMethodName(this.methodName);
        request.setParamtersDesc(this.paramsDesc);
        request.setInterfaceName(this.provider.getInterface().getName());
        String rid = (String)headers.get(REQUEST_ID);
        if (rid == null) {
            rid = (String)headers.get(Metadata.Key.of((String)URLParamType.requestIdFromClient.getName().toLowerCase(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        }
        if (rid != null) {
            request.setAttachment(URLParamType.requestIdFromClient.getName(), rid);
        }
        Set keys = headers.keys();
        for (String key : keys) {
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            if (value == null) continue;
            request.setAttachment(key, value);
        }
        return request;
    }

    private static final class ServerCallStreamObserverImpl<ReqT, RespT>
    extends ServerCallStreamObserver<RespT> {
        final ServerCall<ReqT, RespT> call;
        volatile boolean cancelled;
        private boolean frozen;
        private boolean autoFlowControlEnabled = true;
        private boolean sentHeaders;
        private Runnable onReadyHandler;
        private Runnable onCancelHandler;

        ServerCallStreamObserverImpl(ServerCall<ReqT, RespT> call) {
            this.call = call;
        }

        private void freeze() {
            this.frozen = true;
        }

        public void setMessageCompression(boolean enable) {
            this.call.setMessageCompression(enable);
        }

        public void setCompression(String compression) {
            this.call.setCompression(compression);
        }

        public void onNext(RespT response) {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            if (!this.sentHeaders) {
                this.call.sendHeaders(new Metadata());
                this.sentHeaders = true;
            }
            this.call.sendMessage(response);
        }

        public void onError(Throwable t) {
            Metadata metadata = Status.trailersFromThrowable((Throwable)t);
            if (metadata == null) {
                metadata = new Metadata();
            }
            if (t instanceof MotanBizException) {
                this.call.close(Status.INTERNAL.withDescription(t.getMessage()).withCause(t), metadata);
            } else {
                this.call.close(Status.UNAVAILABLE.withDescription(t.getMessage()).withCause(t), metadata);
            }
        }

        public void onCompleted() {
            if (this.cancelled) {
                throw Status.CANCELLED.asRuntimeException();
            }
            this.call.close(Status.OK, new Metadata());
        }

        public boolean isReady() {
            return this.call.isReady();
        }

        public void setOnReadyHandler(Runnable r) {
            if (this.frozen) {
                throw new IllegalStateException("Cannot alter onReadyHandler after initialization");
            }
            this.onReadyHandler = r;
        }

        public boolean isCancelled() {
            return this.call.isCancelled();
        }

        public void setOnCancelHandler(Runnable onCancelHandler) {
            if (this.frozen) {
                throw new IllegalStateException("Cannot alter onCancelHandler after initialization");
            }
            this.onCancelHandler = onCancelHandler;
        }

        public void disableAutoInboundFlowControl() {
            if (this.frozen) {
                throw new IllegalStateException("Cannot disable auto flow control after initialization");
            }
            this.autoFlowControlEnabled = false;
        }

        public void request(int count) {
            this.call.request(count);
        }
    }
}

