/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.util.JsonFormat;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.grpc.MotanServerCallHandler;
import com.weibo.api.motan.protocol.grpc.annotation.GrpcConfig;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class GrpcUtil {
    private static HashMap<String, HashMap<String, MethodDescriptor>> serviceMap = new HashMap();
    public static final String JSON_CODEC = "grpc-pb-json";

    public static ServerServiceDefinition getServiceDefByAnnotation(Class<?> clazz) throws Exception {
        ServiceDescriptor serviceDesc = GrpcUtil.getServiceDesc(GrpcUtil.getGrpcClassName(clazz));
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)serviceDesc);
        for (MethodDescriptor methodDesc : serviceDesc.getMethods()) {
            builder.addMethod(methodDesc, new MotanServerCallHandler());
        }
        return builder.build();
    }

    private static String getGrpcClassName(Class<?> clazz) {
        GrpcConfig config = clazz.getAnnotation(GrpcConfig.class);
        if (config == null || StringUtils.isBlank((CharSequence)config.grpc())) {
            throw new MotanFrameworkException("can not find grpc config in class " + clazz.getName());
        }
        return config.grpc();
    }

    public static ServiceDescriptor getServiceDesc(String clazzName) throws Exception {
        Class<?> clazz = Class.forName(clazzName);
        return (ServiceDescriptor)clazz.getMethod("getServiceDescriptor", null).invoke(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, MethodDescriptor> getMethodDescriptorByAnnotation(Class<?> clazz, String serialization) throws Exception {
        String clazzName = GrpcUtil.getGrpcClassName(clazz);
        HashMap<String, MethodDescriptor> result = serviceMap.get(clazzName);
        if (result == null) {
            HashMap<String, HashMap<String, MethodDescriptor>> hashMap = serviceMap;
            synchronized (hashMap) {
                if (!serviceMap.containsKey(clazzName)) {
                    ServiceDescriptor serviceDesc = GrpcUtil.getServiceDesc(GrpcUtil.getGrpcClassName(clazz));
                    HashMap<String, MethodDescriptor> methodMap = new HashMap<String, MethodDescriptor>();
                    for (MethodDescriptor methodDesc : serviceDesc.getMethods()) {
                        Method interfaceMethod = GrpcUtil.getMethod(methodDesc.getFullMethodName(), clazz);
                        if (JSON_CODEC.equals(serialization)) {
                            methodDesc = GrpcUtil.convertJsonDescriptor(methodDesc, interfaceMethod.getParameterTypes()[0], interfaceMethod.getReturnType());
                        }
                        methodMap.put(interfaceMethod.getName(), methodDesc);
                    }
                    serviceMap.put(clazzName, methodMap);
                }
                result = serviceMap.get(clazzName);
            }
        }
        return result;
    }

    public static Method getMethod(String name, Class<?> interfaceClazz) {
        Method[] methods;
        int index = name.lastIndexOf("/");
        if (index > -1) {
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        for (Method m : methods = interfaceClazz.getMethods()) {
            if (!m.getName().equalsIgnoreCase(name)) continue;
            return m;
        }
        throw new MotanFrameworkException("not find grpc method");
    }

    public static MethodDescriptor convertJsonDescriptor(MethodDescriptor oldDesc, Class req, Class res) {
        MethodDescriptor.Marshaller reqMarshaller = GrpcUtil.getJsonMarshaller(req);
        MethodDescriptor.Marshaller resMarshaller = GrpcUtil.getJsonMarshaller(res);
        if (reqMarshaller != null && resMarshaller != null) {
            return MethodDescriptor.create((MethodDescriptor.MethodType)oldDesc.getType(), (String)oldDesc.getFullMethodName(), (MethodDescriptor.Marshaller)reqMarshaller, (MethodDescriptor.Marshaller)resMarshaller);
        }
        return null;
    }

    public static MethodDescriptor.Marshaller getJsonMarshaller(Class clazz) {
        try {
            if (MessageLite.class.isAssignableFrom(clazz)) {
                Method method = clazz.getDeclaredMethod("getDefaultInstance", null);
                Message message = (Message)method.invoke(null, null);
                return GrpcUtil.jsonMarshaller(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static <T extends Message> MethodDescriptor.Marshaller<T> jsonMarshaller(final T defaultInstance) {
        final JsonFormat.Printer printer = JsonFormat.printer().preservingProtoFieldNames();
        final JsonFormat.Parser parser = JsonFormat.parser();
        final Charset charset = Charset.forName("UTF-8");
        return new MethodDescriptor.Marshaller<T>(){

            public InputStream stream(T value) {
                try {
                    return new ByteArrayInputStream(printer.print(value).getBytes(charset));
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withCause((Throwable)e).withDescription("Unable to print json proto").asRuntimeException();
                }
            }

            public T parse(InputStream stream) {
                Message proto;
                Message.Builder builder = defaultInstance.newBuilderForType();
                InputStreamReader reader = new InputStreamReader(stream, charset);
                try {
                    parser.merge((Reader)reader, builder);
                    proto = builder.build();
                    ((Reader)reader).close();
                }
                catch (InvalidProtocolBufferException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
                }
                catch (IOException e) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
                }
                return proto;
            }
        };
    }
}

