/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.grpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.protocol.grpc.GrpcUtil;
import com.weibo.api.motan.protocol.grpc.MotanServerCallHandler;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.util.LoggerUtil;
import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class MotanHandlerRegistry
extends HandlerRegistry {
    private ConcurrentHashMap<String, ServerMethodDefinition<?, ?>> methods = new ConcurrentHashMap();

    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, String authority) {
        return this.methods.get(methodName);
    }

    public void addService(ServerServiceDefinition service, Provider provider) {
        for (ServerMethodDefinition method : service.getMethods()) {
            MethodDescriptor jsonDesc;
            MotanServerCallHandler handler;
            Method providerMethod = GrpcUtil.getMethod(method.getMethodDescriptor().getFullMethodName(), provider.getInterface());
            if (method.getServerCallHandler() instanceof MotanServerCallHandler) {
                handler = (MotanServerCallHandler)method.getServerCallHandler();
            } else {
                handler = new MotanServerCallHandler();
                method = method.withServerCallHandler(handler);
            }
            handler.init(provider, providerMethod);
            if ("grpc-pb-json".equals(provider.getUrl().getParameter(URLParamType.serialize.getName())) && (jsonDesc = GrpcUtil.convertJsonDescriptor(method.getMethodDescriptor(), providerMethod.getParameterTypes()[0], providerMethod.getReturnType())) != null) {
                method = ServerMethodDefinition.create((MethodDescriptor)jsonDesc, (ServerCallHandler)method.getServerCallHandler());
                LoggerUtil.info((String)("grpc method " + jsonDesc.getFullMethodName() + " use codec json."));
            }
            this.methods.put(method.getMethodDescriptor().getFullMethodName(), method);
        }
    }

    public void addService(BindableService bindableService, Provider provider) {
        this.addService(bindableService.bindService(), provider);
    }

    public void removeService(ServerServiceDefinition service) {
        if (service != null) {
            for (ServerMethodDefinition method : service.getMethods()) {
                this.methods.remove(method.getMethodDescriptor().getFullMethodName());
            }
        }
    }
}

