/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CircularRecorder<T> {
    int size;
    AtomicInteger index = new AtomicInteger(0);
    Entry<?>[] array;

    public CircularRecorder(int size) {
        this.size = size;
        this.array = new Entry[size];
    }

    public void add(T t) {
        int i = this.index.getAndIncrement();
        if (i < 0) {
            i = -i;
        }
        this.array[i % this.size] = new Entry<T>(t, System.currentTimeMillis());
    }

    public Map<String, T> getRecords() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.size; ++i) {
            Entry<?> temp = this.array[i];
            if (temp == null) continue;
            map.put(i + ":" + temp.timestamp, temp.value);
        }
        return map;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.index.set(0);
    }

    static class Entry<T> {
        T value;
        long timestamp;

        public Entry(T value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

