/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.rpc;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import java.util.HashMap;
import java.util.Map;

public class RpcContext {
    private static final ThreadLocal<RpcContext> LOCAL_CONTEXT = new ThreadLocal<RpcContext>(){

        @Override
        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };
    private Map<Object, Object> attributes = new HashMap<Object, Object>();
    private Map<String, String> attachments = new HashMap<String, String>();
    private Request request;
    private Response response;
    private String clientRequestId = null;

    public static RpcContext getContext() {
        return LOCAL_CONTEXT.get();
    }

    public static RpcContext init(Request request) {
        RpcContext context = new RpcContext();
        if (request != null) {
            context.setRequest(request);
            context.setClientRequestId(request.getAttachments().get(URLParamType.requestIdFromClient.getName()));
        }
        LOCAL_CONTEXT.set(context);
        return context;
    }

    public static RpcContext init() {
        RpcContext context = new RpcContext();
        LOCAL_CONTEXT.set(context);
        return context;
    }

    public static void destroy() {
        LOCAL_CONTEXT.remove();
    }

    public String getRequestId() {
        if (this.clientRequestId != null) {
            return this.clientRequestId;
        }
        return this.request == null ? null : String.valueOf(this.request.getRequestId());
    }

    public void putAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public void setRpcAttachment(String key, String value) {
        this.attachments.put(key, value);
    }

    public String getRpcAttachment(String key) {
        return this.attachments.get(key);
    }

    public void removeRpcAttachment(String key) {
        this.attachments.remove(key);
    }

    public Map<String, String> getRpcAttachments() {
        return this.attachments;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public void setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
    }
}

